/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRAttribute
extends Struct<EXRAttribute>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int VALUE;
    public static final int SIZE;

    protected EXRAttribute(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected EXRAttribute create(long address, @Nullable ByteBuffer container) {
        return new EXRAttribute(address, container);
    }

    public EXRAttribute(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EXRAttribute.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return EXRAttribute.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return EXRAttribute.nnameString(this.address());
    }

    @NativeType(value="char[256]")
    public ByteBuffer type() {
        return EXRAttribute.ntype(this.address());
    }

    @NativeType(value="char[256]")
    public String typeString() {
        return EXRAttribute.ntypeString(this.address());
    }

    @NativeType(value="unsigned char *")
    public @Nullable ByteBuffer value() {
        return EXRAttribute.nvalue(this.address());
    }

    public int size() {
        return EXRAttribute.nsize(this.address());
    }

    public EXRAttribute name(@NativeType(value="char[256]") ByteBuffer value) {
        EXRAttribute.nname(this.address(), value);
        return this;
    }

    public EXRAttribute type(@NativeType(value="char[256]") ByteBuffer value) {
        EXRAttribute.ntype(this.address(), value);
        return this;
    }

    public EXRAttribute value(@NativeType(value="unsigned char *") @Nullable ByteBuffer value) {
        EXRAttribute.nvalue(this.address(), value);
        return this;
    }

    public EXRAttribute set(ByteBuffer name, ByteBuffer type, @Nullable ByteBuffer value) {
        this.name(name);
        this.type(type);
        this.value(value);
        return this;
    }

    public EXRAttribute set(EXRAttribute src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EXRAttribute malloc() {
        return new EXRAttribute(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static EXRAttribute calloc() {
        return new EXRAttribute(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static EXRAttribute create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new EXRAttribute(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static EXRAttribute create(long address) {
        return new EXRAttribute(address, null);
    }

    public static @Nullable EXRAttribute createSafe(long address) {
        return address == 0L ? null : new EXRAttribute(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)EXRAttribute.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRAttribute.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static EXRAttribute mallocStack() {
        return EXRAttribute.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRAttribute callocStack() {
        return EXRAttribute.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRAttribute mallocStack(MemoryStack stack) {
        return EXRAttribute.malloc(stack);
    }

    @Deprecated
    public static EXRAttribute callocStack(MemoryStack stack) {
        return EXRAttribute.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EXRAttribute.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EXRAttribute.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRAttribute.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRAttribute.calloc(capacity, stack);
    }

    public static EXRAttribute malloc(MemoryStack stack) {
        return new EXRAttribute(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EXRAttribute calloc(MemoryStack stack) {
        return new EXRAttribute(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static ByteBuffer ntype(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)TYPE), (int)256);
    }

    public static String ntypeString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)TYPE));
    }

    public static @Nullable ByteBuffer nvalue(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)VALUE)), (int)EXRAttribute.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)NAME), (long)value.remaining());
    }

    public static void ntype(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)TYPE), (long)value.remaining());
    }

    public static void nvalue(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VALUE), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        EXRAttribute.nsize(struct, value == null ? 0 : value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void validate(long struct) {
        if (EXRAttribute.nsize(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VALUE)));
        }
    }

    static {
        Struct.Layout layout = EXRAttribute.__struct((Struct.Member[])new Struct.Member[]{EXRAttribute.__array((int)1, (int)256), EXRAttribute.__array((int)1, (int)256), EXRAttribute.__member((int)POINTER_SIZE), EXRAttribute.__member((int)4), EXRAttribute.__padding((int)4, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        SIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EXRAttribute, Buffer>
    implements NativeResource {
        private static final EXRAttribute ELEMENT_FACTORY = EXRAttribute.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected EXRAttribute getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return EXRAttribute.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return EXRAttribute.nnameString(this.address());
        }

        @NativeType(value="char[256]")
        public ByteBuffer type() {
            return EXRAttribute.ntype(this.address());
        }

        @NativeType(value="char[256]")
        public String typeString() {
            return EXRAttribute.ntypeString(this.address());
        }

        @NativeType(value="unsigned char *")
        public @Nullable ByteBuffer value() {
            return EXRAttribute.nvalue(this.address());
        }

        public int size() {
            return EXRAttribute.nsize(this.address());
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            EXRAttribute.nname(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="char[256]") ByteBuffer value) {
            EXRAttribute.ntype(this.address(), value);
            return this;
        }

        public Buffer value(@NativeType(value="unsigned char *") @Nullable ByteBuffer value) {
            EXRAttribute.nvalue(this.address(), value);
            return this;
        }
    }
}

