/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaStatistics;

public class VmaBudget
extends Struct<VmaBudget>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STATISTICS;
    public static final int USAGE;
    public static final int BUDGET;

    protected VmaBudget(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaBudget create(long address, @Nullable ByteBuffer container) {
        return new VmaBudget(address, container);
    }

    public VmaBudget(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaBudget.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VmaStatistics statistics() {
        return VmaBudget.nstatistics(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long usage() {
        return VmaBudget.nusage(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long budget() {
        return VmaBudget.nbudget(this.address());
    }

    public static VmaBudget malloc() {
        return new VmaBudget(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaBudget calloc() {
        return new VmaBudget(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaBudget create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaBudget(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaBudget create(long address) {
        return new VmaBudget(address, null);
    }

    public static @Nullable VmaBudget createSafe(long address) {
        return address == 0L ? null : new VmaBudget(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaBudget.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaBudget.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaBudget malloc(MemoryStack stack) {
        return new VmaBudget(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaBudget calloc(MemoryStack stack) {
        return new VmaBudget(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VmaStatistics nstatistics(long struct) {
        return VmaStatistics.create(struct + (long)STATISTICS);
    }

    public static long nusage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)USAGE));
    }

    public static long nbudget(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUDGET));
    }

    static {
        Struct.Layout layout = VmaBudget.__struct((Struct.Member[])new Struct.Member[]{VmaBudget.__member((int)VmaStatistics.SIZEOF, (int)VmaStatistics.ALIGNOF), VmaBudget.__member((int)8), VmaBudget.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STATISTICS = layout.offsetof(0);
        USAGE = layout.offsetof(1);
        BUDGET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaBudget, Buffer>
    implements NativeResource {
        private static final VmaBudget ELEMENT_FACTORY = VmaBudget.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VmaBudget getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VmaStatistics statistics() {
            return VmaBudget.nstatistics(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long usage() {
            return VmaBudget.nusage(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long budget() {
            return VmaBudget.nbudget(this.address());
        }
    }
}

