/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaVirtualAllocationInfo
extends Struct<VmaVirtualAllocationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PUSERDATA;

    protected VmaVirtualAllocationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaVirtualAllocationInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaVirtualAllocationInfo(address, container);
    }

    public VmaVirtualAllocationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaVirtualAllocationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VmaVirtualAllocationInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualAllocationInfo.nsize(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaVirtualAllocationInfo.npUserData(this.address());
    }

    public static VmaVirtualAllocationInfo malloc() {
        return new VmaVirtualAllocationInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaVirtualAllocationInfo calloc() {
        return new VmaVirtualAllocationInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaVirtualAllocationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaVirtualAllocationInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaVirtualAllocationInfo create(long address) {
        return new VmaVirtualAllocationInfo(address, null);
    }

    public static @Nullable VmaVirtualAllocationInfo createSafe(long address) {
        return address == 0L ? null : new VmaVirtualAllocationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaVirtualAllocationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualAllocationInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaVirtualAllocationInfo malloc(MemoryStack stack) {
        return new VmaVirtualAllocationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaVirtualAllocationInfo calloc(MemoryStack stack) {
        return new VmaVirtualAllocationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    static {
        Struct.Layout layout = VmaVirtualAllocationInfo.__struct((Struct.Member[])new Struct.Member[]{VmaVirtualAllocationInfo.__member((int)8), VmaVirtualAllocationInfo.__member((int)8), VmaVirtualAllocationInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        PUSERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualAllocationInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualAllocationInfo ELEMENT_FACTORY = VmaVirtualAllocationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VmaVirtualAllocationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VmaVirtualAllocationInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualAllocationInfo.nsize(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaVirtualAllocationInfo.npUserData(this.address());
        }
    }
}

