/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

import org.jspecify.annotations.*;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

import org.lwjgl.vulkan.video.*;

/**
 * Structure specifying AV1 decode profile.
 * 
 * <h5>Description</h5>
 * 
 * <div style="margin-left: 26px; border-left: 1px solid gray; padding-left: 14px;"><h5>Note</h5>
 * 
 * <p>Enabling {@code filmGrainSupport} <b>may</b> increase the memory requirements of video sessions and/or video picture resources on some implementations.</p>
 * </div>
 * 
 * <h5>Valid Usage (Implicit)</h5>
 * 
 * <ul>
 * <li>{@code sType} <b>must</b> be {@link KHRVideoDecodeAV1#VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR}</li>
 * </ul>
 * 
 * <h3>Layout</h3>
 * 
 * <pre><code>
 * struct VkVideoDecodeAV1ProfileInfoKHR {
 *     VkStructureType {@link #sType};
 *     void const * {@link #pNext};
 *     StdVideoAV1Profile {@link #stdProfile};
 *     VkBool32 {@link #filmGrainSupport};
 * }</code></pre>
 */
public class VkVideoDecodeAV1ProfileInfoKHR extends Struct<VkVideoDecodeAV1ProfileInfoKHR> implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    /** The struct alignment in bytes. */
    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        STYPE,
        PNEXT,
        STDPROFILE,
        FILMGRAINSUPPORT;

    static {
        Layout layout = __struct(
            __member(4),
            __member(POINTER_SIZE),
            __member(4),
            __member(4)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STDPROFILE = layout.offsetof(2);
        FILMGRAINSUPPORT = layout.offsetof(3);
    }

    protected VkVideoDecodeAV1ProfileInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoDecodeAV1ProfileInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoDecodeAV1ProfileInfoKHR(address, container);
    }

    /**
     * Creates a {@code VkVideoDecodeAV1ProfileInfoKHR} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public VkVideoDecodeAV1ProfileInfoKHR(ByteBuffer container) {
        super(memAddress(container), __checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** a {@code VkStructureType} value identifying this structure. */
    @NativeType("VkStructureType")
    public int sType() { return nsType(address()); }
    /** {@code NULL} or a pointer to a structure extending this structure. */
    @NativeType("void const *")
    public long pNext() { return npNext(address()); }
    /** a {@code StdVideoAV1Profile} value specifying the AV1 codec profile, as defined in section A.2 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html#aomedia-av1">AV1 Specification</a>. */
    @NativeType("StdVideoAV1Profile")
    public int stdProfile() { return nstdProfile(address()); }
    /** specifies whether AV1 film grain, as defined in section 7.8.3 of the <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html#aomedia-av1">AV1 Specification</a>, <b>can</b> be used with the video profile. When this member is {@link VK10#VK_TRUE TRUE}, video session objects created against the video profile will be able to decode pictures that have <a href="https://registry.khronos.org/vulkan/specs/latest/html/vkspec.html#decode-av1-film-grain">film grain</a> enabled. */
    @NativeType("VkBool32")
    public boolean filmGrainSupport() { return nfilmGrainSupport(address()) != 0; }

    /** Sets the specified value to the {@link #sType} field. */
    public VkVideoDecodeAV1ProfileInfoKHR sType(@NativeType("VkStructureType") int value) { nsType(address(), value); return this; }
    /** Sets the {@link KHRVideoDecodeAV1#VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR} value to the {@link #sType} field. */
    public VkVideoDecodeAV1ProfileInfoKHR sType$Default() { return sType(KHRVideoDecodeAV1.VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR); }
    /** Sets the specified value to the {@link #pNext} field. */
    public VkVideoDecodeAV1ProfileInfoKHR pNext(@NativeType("void const *") long value) { npNext(address(), value); return this; }
    /** Sets the specified value to the {@link #stdProfile} field. */
    public VkVideoDecodeAV1ProfileInfoKHR stdProfile(@NativeType("StdVideoAV1Profile") int value) { nstdProfile(address(), value); return this; }
    /** Sets the specified value to the {@link #filmGrainSupport} field. */
    public VkVideoDecodeAV1ProfileInfoKHR filmGrainSupport(@NativeType("VkBool32") boolean value) { nfilmGrainSupport(address(), value ? 1 : 0); return this; }

    /** Initializes this struct with the specified values. */
    public VkVideoDecodeAV1ProfileInfoKHR set(
        int sType,
        long pNext,
        int stdProfile,
        boolean filmGrainSupport
    ) {
        sType(sType);
        pNext(pNext);
        stdProfile(stdProfile);
        filmGrainSupport(filmGrainSupport);

        return this;
    }

    /**
     * Copies the specified struct data to this struct.
     *
     * @param src the source struct
     *
     * @return this struct
     */
    public VkVideoDecodeAV1ProfileInfoKHR set(VkVideoDecodeAV1ProfileInfoKHR src) {
        memCopy(src.address(), address(), SIZEOF);
        return this;
    }

    // -----------------------------------

    /** Returns a new {@code VkVideoDecodeAV1ProfileInfoKHR} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static VkVideoDecodeAV1ProfileInfoKHR malloc() {
        return new VkVideoDecodeAV1ProfileInfoKHR(nmemAllocChecked(SIZEOF), null);
    }

    /** Returns a new {@code VkVideoDecodeAV1ProfileInfoKHR} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static VkVideoDecodeAV1ProfileInfoKHR calloc() {
        return new VkVideoDecodeAV1ProfileInfoKHR(nmemCallocChecked(1, SIZEOF), null);
    }

    /** Returns a new {@code VkVideoDecodeAV1ProfileInfoKHR} instance allocated with {@link BufferUtils}. */
    public static VkVideoDecodeAV1ProfileInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoDecodeAV1ProfileInfoKHR(memAddress(container), container);
    }

    /** Returns a new {@code VkVideoDecodeAV1ProfileInfoKHR} instance for the specified memory address. */
    public static VkVideoDecodeAV1ProfileInfoKHR create(long address) {
        return new VkVideoDecodeAV1ProfileInfoKHR(address, null);
    }

    /** Like {@link #create(long) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    public static @Nullable VkVideoDecodeAV1ProfileInfoKHR createSafe(long address) {
        return address == NULL ? null : new VkVideoDecodeAV1ProfileInfoKHR(address, null);
    }

    /**
     * Returns a new {@link VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkVideoDecodeAV1ProfileInfoKHR.Buffer malloc(int capacity) {
        return new Buffer(nmemAllocChecked(__checkMalloc(capacity, SIZEOF)), capacity);
    }

    /**
     * Returns a new {@link VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static VkVideoDecodeAV1ProfileInfoKHR.Buffer calloc(int capacity) {
        return new Buffer(nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static VkVideoDecodeAV1ProfileInfoKHR.Buffer create(int capacity) {
        ByteBuffer container = __create(capacity, SIZEOF);
        return new Buffer(memAddress(container), container, -1, 0, capacity, capacity);
    }

    /**
     * Create a {@link VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static VkVideoDecodeAV1ProfileInfoKHR.Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    /** Like {@link #create(long, int) create}, but returns {@code null} if {@code address} is {@code NULL}. */
    public static VkVideoDecodeAV1ProfileInfoKHR.@Nullable Buffer createSafe(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, capacity);
    }

    /**
     * Returns a new {@code VkVideoDecodeAV1ProfileInfoKHR} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static VkVideoDecodeAV1ProfileInfoKHR malloc(MemoryStack stack) {
        return new VkVideoDecodeAV1ProfileInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    /**
     * Returns a new {@code VkVideoDecodeAV1ProfileInfoKHR} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static VkVideoDecodeAV1ProfileInfoKHR calloc(MemoryStack stack) {
        return new VkVideoDecodeAV1ProfileInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    /**
     * Returns a new {@link VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkVideoDecodeAV1ProfileInfoKHR.Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack    the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static VkVideoDecodeAV1ProfileInfoKHR.Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #sType}. */
    public static int nsType(long struct) { return memGetInt(struct + VkVideoDecodeAV1ProfileInfoKHR.STYPE); }
    /** Unsafe version of {@link #pNext}. */
    public static long npNext(long struct) { return memGetAddress(struct + VkVideoDecodeAV1ProfileInfoKHR.PNEXT); }
    /** Unsafe version of {@link #stdProfile}. */
    public static int nstdProfile(long struct) { return memGetInt(struct + VkVideoDecodeAV1ProfileInfoKHR.STDPROFILE); }
    /** Unsafe version of {@link #filmGrainSupport}. */
    public static int nfilmGrainSupport(long struct) { return memGetInt(struct + VkVideoDecodeAV1ProfileInfoKHR.FILMGRAINSUPPORT); }

    /** Unsafe version of {@link #sType(int) sType}. */
    public static void nsType(long struct, int value) { memPutInt(struct + VkVideoDecodeAV1ProfileInfoKHR.STYPE, value); }
    /** Unsafe version of {@link #pNext(long) pNext}. */
    public static void npNext(long struct, long value) { memPutAddress(struct + VkVideoDecodeAV1ProfileInfoKHR.PNEXT, value); }
    /** Unsafe version of {@link #stdProfile(int) stdProfile}. */
    public static void nstdProfile(long struct, int value) { memPutInt(struct + VkVideoDecodeAV1ProfileInfoKHR.STDPROFILE, value); }
    /** Unsafe version of {@link #filmGrainSupport(boolean) filmGrainSupport}. */
    public static void nfilmGrainSupport(long struct, int value) { memPutInt(struct + VkVideoDecodeAV1ProfileInfoKHR.FILMGRAINSUPPORT, value); }

    // -----------------------------------

    /** An array of {@link VkVideoDecodeAV1ProfileInfoKHR} structs. */
    public static class Buffer extends StructBuffer<VkVideoDecodeAV1ProfileInfoKHR, Buffer> implements NativeResource {

        private static final VkVideoDecodeAV1ProfileInfoKHR ELEMENT_FACTORY = VkVideoDecodeAV1ProfileInfoKHR.create(-1L);

        /**
         * Creates a new {@code VkVideoDecodeAV1ProfileInfoKHR.Buffer} instance backed by the specified container.
         *
         * <p>Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link VkVideoDecodeAV1ProfileInfoKHR#SIZEOF}, and its mark will be undefined.</p>
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkVideoDecodeAV1ProfileInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        /** @return the value of the {@link VkVideoDecodeAV1ProfileInfoKHR#sType} field. */
        @NativeType("VkStructureType")
        public int sType() { return VkVideoDecodeAV1ProfileInfoKHR.nsType(address()); }
        /** @return the value of the {@link VkVideoDecodeAV1ProfileInfoKHR#pNext} field. */
        @NativeType("void const *")
        public long pNext() { return VkVideoDecodeAV1ProfileInfoKHR.npNext(address()); }
        /** @return the value of the {@link VkVideoDecodeAV1ProfileInfoKHR#stdProfile} field. */
        @NativeType("StdVideoAV1Profile")
        public int stdProfile() { return VkVideoDecodeAV1ProfileInfoKHR.nstdProfile(address()); }
        /** @return the value of the {@link VkVideoDecodeAV1ProfileInfoKHR#filmGrainSupport} field. */
        @NativeType("VkBool32")
        public boolean filmGrainSupport() { return VkVideoDecodeAV1ProfileInfoKHR.nfilmGrainSupport(address()) != 0; }

        /** Sets the specified value to the {@link VkVideoDecodeAV1ProfileInfoKHR#sType} field. */
        public VkVideoDecodeAV1ProfileInfoKHR.Buffer sType(@NativeType("VkStructureType") int value) { VkVideoDecodeAV1ProfileInfoKHR.nsType(address(), value); return this; }
        /** Sets the {@link KHRVideoDecodeAV1#VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR} value to the {@link VkVideoDecodeAV1ProfileInfoKHR#sType} field. */
        public VkVideoDecodeAV1ProfileInfoKHR.Buffer sType$Default() { return sType(KHRVideoDecodeAV1.VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR); }
        /** Sets the specified value to the {@link VkVideoDecodeAV1ProfileInfoKHR#pNext} field. */
        public VkVideoDecodeAV1ProfileInfoKHR.Buffer pNext(@NativeType("void const *") long value) { VkVideoDecodeAV1ProfileInfoKHR.npNext(address(), value); return this; }
        /** Sets the specified value to the {@link VkVideoDecodeAV1ProfileInfoKHR#stdProfile} field. */
        public VkVideoDecodeAV1ProfileInfoKHR.Buffer stdProfile(@NativeType("StdVideoAV1Profile") int value) { VkVideoDecodeAV1ProfileInfoKHR.nstdProfile(address(), value); return this; }
        /** Sets the specified value to the {@link VkVideoDecodeAV1ProfileInfoKHR#filmGrainSupport} field. */
        public VkVideoDecodeAV1ProfileInfoKHR.Buffer filmGrainSupport(@NativeType("VkBool32") boolean value) { VkVideoDecodeAV1ProfileInfoKHR.nfilmGrainSupport(address(), value ? 1 : 0); return this; }

    }

}