/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceEventInfoEXT;
import org.lwjgl.vulkan.VkDisplayEventInfoEXT;
import org.lwjgl.vulkan.VkDisplayPowerInfoEXT;

public class EXTDisplayControl {
    public static final int VK_EXT_DISPLAY_CONTROL_SPEC_VERSION = 1;
    public static final String VK_EXT_DISPLAY_CONTROL_EXTENSION_NAME = "VK_EXT_display_control";
    public static final int VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT = 1000091000;
    public static final int VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT = 1000091001;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT = 1000091002;
    public static final int VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT = 1000091003;
    public static final int VK_DISPLAY_POWER_STATE_OFF_EXT = 0;
    public static final int VK_DISPLAY_POWER_STATE_SUSPEND_EXT = 1;
    public static final int VK_DISPLAY_POWER_STATE_ON_EXT = 2;
    public static final int VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT = 0;
    public static final int VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT = 0;

    protected EXTDisplayControl() {
        throw new UnsupportedOperationException();
    }

    public static int nvkDisplayPowerControlEXT(VkDevice device, long display, long pDisplayPowerInfo) {
        long __functionAddress = device.getCapabilities().vkDisplayPowerControlEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)display, (long)pDisplayPowerInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkDisplayPowerControlEXT(VkDevice device, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="VkDisplayPowerInfoEXT const *") VkDisplayPowerInfoEXT pDisplayPowerInfo) {
        return EXTDisplayControl.nvkDisplayPowerControlEXT(device, display, pDisplayPowerInfo.address());
    }

    public static int nvkRegisterDeviceEventEXT(VkDevice device, long pDeviceEventInfo, long pAllocator, long pFence) {
        long __functionAddress = device.getCapabilities().vkRegisterDeviceEventEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)device.address(), (long)pDeviceEventInfo, (long)pAllocator, (long)pFence, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkRegisterDeviceEventEXT(VkDevice device, @NativeType(value="VkDeviceEventInfoEXT const *") VkDeviceEventInfoEXT pDeviceEventInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkFence *") LongBuffer pFence) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFence, (int)1);
        }
        return EXTDisplayControl.nvkRegisterDeviceEventEXT(device, pDeviceEventInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pFence));
    }

    public static int nvkRegisterDisplayEventEXT(VkDevice device, long display, long pDisplayEventInfo, long pAllocator, long pFence) {
        long __functionAddress = device.getCapabilities().vkRegisterDisplayEventEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPPI((long)device.address(), (long)display, (long)pDisplayEventInfo, (long)pAllocator, (long)pFence, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkRegisterDisplayEventEXT(VkDevice device, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="VkDisplayEventInfoEXT const *") VkDisplayEventInfoEXT pDisplayEventInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkFence *") LongBuffer pFence) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFence, (int)1);
        }
        return EXTDisplayControl.nvkRegisterDisplayEventEXT(device, display, pDisplayEventInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pFence));
    }

    public static int nvkGetSwapchainCounterEXT(VkDevice device, long swapchain, int counter, long pCounterValue) {
        long __functionAddress = device.getCapabilities().vkGetSwapchainCounterEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)swapchain, (int)counter, (long)pCounterValue, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetSwapchainCounterEXT(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="VkSurfaceCounterFlagBitsEXT") int counter, @NativeType(value="uint64_t *") LongBuffer pCounterValue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCounterValue, (int)1);
        }
        return EXTDisplayControl.nvkGetSwapchainCounterEXT(device, swapchain, counter, MemoryUtil.memAddress((LongBuffer)pCounterValue));
    }

    @NativeType(value="VkResult")
    public static int vkRegisterDeviceEventEXT(VkDevice device, @NativeType(value="VkDeviceEventInfoEXT const *") VkDeviceEventInfoEXT pDeviceEventInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkFence *") long[] pFence) {
        long __functionAddress = device.getCapabilities().vkRegisterDeviceEventEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pFence, (int)1);
        }
        return JNI.callPPPPI((long)device.address(), (long)pDeviceEventInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pFence, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkRegisterDisplayEventEXT(VkDevice device, @NativeType(value="VkDisplayKHR") long display, @NativeType(value="VkDisplayEventInfoEXT const *") VkDisplayEventInfoEXT pDisplayEventInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkFence *") long[] pFence) {
        long __functionAddress = device.getCapabilities().vkRegisterDisplayEventEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pFence, (int)1);
        }
        return JNI.callPJPPPI((long)device.address(), (long)display, (long)pDisplayEventInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pFence, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetSwapchainCounterEXT(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="VkSurfaceCounterFlagBitsEXT") int counter, @NativeType(value="uint64_t *") long[] pCounterValue) {
        long __functionAddress = device.getCapabilities().vkGetSwapchainCounterEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pCounterValue, (int)1);
        }
        return JNI.callPJPI((long)device.address(), (long)swapchain, (int)counter, (long[])pCounterValue, (long)__functionAddress);
    }
}

