/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;

public class KHRDeferredHostOperations {
    public static final int VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION = 4;
    public static final String VK_KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME = "VK_KHR_deferred_host_operations";
    public static final int VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR = 1000268000;
    public static final int VK_THREAD_IDLE_KHR = 1000268000;
    public static final int VK_THREAD_DONE_KHR = 1000268001;
    public static final int VK_OPERATION_DEFERRED_KHR = 1000268002;
    public static final int VK_OPERATION_NOT_DEFERRED_KHR = 1000268003;

    protected KHRDeferredHostOperations() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateDeferredOperationKHR(VkDevice device, long pAllocator, long pDeferredOperation) {
        long __functionAddress = device.getCapabilities().vkCreateDeferredOperationKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pAllocator, (long)pDeferredOperation, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDeferredOperationKHR(VkDevice device, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkDeferredOperationKHR *") LongBuffer pDeferredOperation) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDeferredOperation, (int)1);
        }
        return KHRDeferredHostOperations.nvkCreateDeferredOperationKHR(device, MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pDeferredOperation));
    }

    public static void nvkDestroyDeferredOperationKHR(VkDevice device, long operation, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDeferredOperationKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)device.address(), (long)operation, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroyDeferredOperationKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator) {
        KHRDeferredHostOperations.nvkDestroyDeferredOperationKHR(device, operation, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    @NativeType(value="uint32_t")
    public static int vkGetDeferredOperationMaxConcurrencyKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation) {
        long __functionAddress = device.getCapabilities().vkGetDeferredOperationMaxConcurrencyKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJI((long)device.address(), (long)operation, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDeferredOperationResultKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation) {
        long __functionAddress = device.getCapabilities().vkGetDeferredOperationResultKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJI((long)device.address(), (long)operation, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkDeferredOperationJoinKHR(VkDevice device, @NativeType(value="VkDeferredOperationKHR") long operation) {
        long __functionAddress = device.getCapabilities().vkDeferredOperationJoinKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJI((long)device.address(), (long)operation, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDeferredOperationKHR(VkDevice device, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkDeferredOperationKHR *") long[] pDeferredOperation) {
        long __functionAddress = device.getCapabilities().vkCreateDeferredOperationKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pDeferredOperation, (int)1);
        }
        return JNI.callPPPI((long)device.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pDeferredOperation, (long)__functionAddress);
    }
}

