/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAcquireProfilingLockInfoKHR;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkQueryPoolPerformanceCreateInfoKHR;

public class KHRPerformanceQuery {
    public static final int VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION = 1;
    public static final String VK_KHR_PERFORMANCE_QUERY_EXTENSION_NAME = "VK_KHR_performance_query";
    public static final int VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR = 1000116000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR = 1000116000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR = 1000116001;
    public static final int VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR = 1000116002;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR = 1000116003;
    public static final int VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR = 1000116004;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR = 1000116005;
    public static final int VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR = 1000116006;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR = 0;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR = 1;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR = 2;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR = 3;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR = 4;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR = 5;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR = 6;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR = 7;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR = 8;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR = 9;
    public static final int VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR = 10;
    public static final int VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR = 0;
    public static final int VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR = 1;
    public static final int VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR = 2;
    public static final int VK_QUERY_SCOPE_COMMAND_BUFFER_KHR = 0;
    public static final int VK_QUERY_SCOPE_RENDER_PASS_KHR = 1;
    public static final int VK_QUERY_SCOPE_COMMAND_KHR = 2;
    public static final int VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR = 0;
    public static final int VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR = 1;
    public static final int VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR = 2;
    public static final int VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR = 3;
    public static final int VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR = 4;
    public static final int VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR = 5;
    public static final int VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR = 1;
    public static final int VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_KHR = 1;
    public static final int VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR = 2;
    public static final int VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_KHR = 2;

    protected KHRPerformanceQuery() {
        throw new UnsupportedOperationException();
    }

    public static int nvkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, int queueFamilyIndex, long pCounterCount, long pCounters, long pCounterDescriptions) {
        long __functionAddress = physicalDevice.getCapabilities().vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)physicalDevice.address(), (int)queueFamilyIndex, (long)pCounterCount, (long)pCounters, (long)pCounterDescriptions, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="uint32_t *") IntBuffer pCounterCount, @NativeType(value="VkPerformanceCounterKHR *")  @Nullable VkPerformanceCounterKHR.Buffer pCounters, @NativeType(value="VkPerformanceCounterDescriptionKHR *")  @Nullable VkPerformanceCounterDescriptionKHR.Buffer pCounterDescriptions) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCounterCount, (int)1);
            Checks.checkSafe((CustomBuffer)pCounters, (int)pCounterCount.get(pCounterCount.position()));
            Checks.checkSafe((CustomBuffer)pCounterDescriptions, (int)pCounterCount.get(pCounterCount.position()));
        }
        return KHRPerformanceQuery.nvkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(physicalDevice, queueFamilyIndex, MemoryUtil.memAddress((IntBuffer)pCounterCount), MemoryUtil.memAddressSafe((Pointer)pCounters), MemoryUtil.memAddressSafe((Pointer)pCounterDescriptions));
    }

    public static void nvkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, long pPerformanceQueryCreateInfo, long pNumPasses) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkQueryPoolPerformanceCreateInfoKHR.validate(pPerformanceQueryCreateInfo);
        }
        JNI.callPPPV((long)physicalDevice.address(), (long)pPerformanceQueryCreateInfo, (long)pNumPasses, (long)__functionAddress);
    }

    public static void vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkQueryPoolPerformanceCreateInfoKHR const *") VkQueryPoolPerformanceCreateInfoKHR pPerformanceQueryCreateInfo, @NativeType(value="uint32_t *") IntBuffer pNumPasses) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pNumPasses, (int)1);
        }
        KHRPerformanceQuery.nvkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pNumPasses));
    }

    public static int nvkAcquireProfilingLockKHR(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkAcquireProfilingLockKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkAcquireProfilingLockKHR(VkDevice device, @NativeType(value="VkAcquireProfilingLockInfoKHR const *") VkAcquireProfilingLockInfoKHR pInfo) {
        return KHRPerformanceQuery.nvkAcquireProfilingLockKHR(device, pInfo.address());
    }

    public static void vkReleaseProfilingLockKHR(VkDevice device) {
        long __functionAddress = device.getCapabilities().vkReleaseProfilingLockKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)device.address(), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="uint32_t *") int[] pCounterCount, @NativeType(value="VkPerformanceCounterKHR *")  @Nullable VkPerformanceCounterKHR.Buffer pCounters, @NativeType(value="VkPerformanceCounterDescriptionKHR *")  @Nullable VkPerformanceCounterDescriptionKHR.Buffer pCounterDescriptions) {
        long __functionAddress = physicalDevice.getCapabilities().vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pCounterCount, (int)1);
            Checks.checkSafe((CustomBuffer)pCounters, (int)pCounterCount[0]);
            Checks.checkSafe((CustomBuffer)pCounterDescriptions, (int)pCounterCount[0]);
        }
        return JNI.callPPPPI((long)physicalDevice.address(), (int)queueFamilyIndex, (int[])pCounterCount, (long)MemoryUtil.memAddressSafe((Pointer)pCounters), (long)MemoryUtil.memAddressSafe((Pointer)pCounterDescriptions), (long)__functionAddress);
    }

    public static void vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkQueryPoolPerformanceCreateInfoKHR const *") VkQueryPoolPerformanceCreateInfoKHR pPerformanceQueryCreateInfo, @NativeType(value="uint32_t *") int[] pNumPasses) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pNumPasses, (int)1);
            VkQueryPoolPerformanceCreateInfoKHR.validate(pPerformanceQueryCreateInfo.address());
        }
        JNI.callPPPV((long)physicalDevice.address(), (long)pPerformanceQueryCreateInfo.address(), (int[])pNumPasses, (long)__functionAddress);
    }
}

