/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkXlibSurfaceCreateInfoKHR;

public class KHRXlibSurface {
    public static final int VK_KHR_XLIB_SURFACE_SPEC_VERSION = 6;
    public static final String VK_KHR_XLIB_SURFACE_EXTENSION_NAME = "VK_KHR_xlib_surface";
    public static final int VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR = 1000004000;

    protected KHRXlibSurface() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateXlibSurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateXlibSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo, (long)pAllocator, (long)pSurface, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateXlibSurfaceKHR(VkInstance instance, @NativeType(value="VkXlibSurfaceCreateInfoKHR const *") VkXlibSurfaceCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, (int)1);
        }
        return KHRXlibSurface.nvkCreateXlibSurfaceKHR(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pSurface));
    }

    @NativeType(value="VkBool32")
    public static boolean vkGetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="Display *") long dpy, @NativeType(value="VisualID") long visualID) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceXlibPresentationSupportKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
        }
        return JNI.callPPNI((long)physicalDevice.address(), (int)queueFamilyIndex, (long)dpy, (long)visualID, (long)__functionAddress) != 0;
    }

    @NativeType(value="VkResult")
    public static int vkCreateXlibSurfaceKHR(VkInstance instance, @NativeType(value="VkXlibSurfaceCreateInfoKHR const *") VkXlibSurfaceCreateInfoKHR pCreateInfo, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateXlibSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pSurface, (int)1);
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pSurface, (long)__functionAddress);
    }
}

