/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImageViewAddressPropertiesNVX;
import org.lwjgl.vulkan.VkImageViewHandleInfoNVX;

public class NVXImageViewHandle {
    public static final int VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION = 3;
    public static final String VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME = "VK_NVX_image_view_handle";
    public static final int VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX = 1000030000;
    public static final int VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX = 1000030001;

    protected NVXImageViewHandle() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetImageViewHandleNVX(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetImageViewHandleNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int vkGetImageViewHandleNVX(VkDevice device, @NativeType(value="VkImageViewHandleInfoNVX const *") VkImageViewHandleInfoNVX pInfo) {
        return NVXImageViewHandle.nvkGetImageViewHandleNVX(device, pInfo.address());
    }

    public static long nvkGetImageViewHandle64NVX(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetImageViewHandle64NVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJ((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long vkGetImageViewHandle64NVX(VkDevice device, @NativeType(value="VkImageViewHandleInfoNVX const *") VkImageViewHandleInfoNVX pInfo) {
        return NVXImageViewHandle.nvkGetImageViewHandle64NVX(device, pInfo.address());
    }

    public static int nvkGetImageViewAddressNVX(VkDevice device, long imageView, long pProperties) {
        long __functionAddress = device.getCapabilities().vkGetImageViewAddressNVX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)imageView, (long)pProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetImageViewAddressNVX(VkDevice device, @NativeType(value="VkImageView") long imageView, @NativeType(value="VkImageViewAddressPropertiesNVX *") VkImageViewAddressPropertiesNVX pProperties) {
        return NVXImageViewHandle.nvkGetImageViewAddressNVX(device, imageView, pProperties.address());
    }
}

