/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryKHR;
import org.lwjgl.vulkan.VkDeviceOrHostAddressKHR;

public class VkAccelerationStructureBuildGeometryInfoKHR
extends Struct<VkAccelerationStructureBuildGeometryInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int MODE;
    public static final int SRCACCELERATIONSTRUCTURE;
    public static final int DSTACCELERATIONSTRUCTURE;
    public static final int GEOMETRYCOUNT;
    public static final int PGEOMETRIES;
    public static final int PPGEOMETRIES;
    public static final int SCRATCHDATA;

    protected VkAccelerationStructureBuildGeometryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAccelerationStructureBuildGeometryInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureBuildGeometryInfoKHR(address, container);
    }

    public VkAccelerationStructureBuildGeometryInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureBuildGeometryInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureTypeKHR")
    public int type() {
        return VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address());
    }

    @NativeType(value="VkBuildAccelerationStructureFlagsKHR")
    public int flags() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkBuildAccelerationStructureModeKHR")
    public int mode() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long srcAccelerationStructure() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long dstAccelerationStructure() {
        return VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address());
    }

    @NativeType(value="uint32_t")
    public int geometryCount() {
        return VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address());
    }

    @NativeType(value="VkAccelerationStructureGeometryKHR const *")
    public @Nullable VkAccelerationStructureGeometryKHR.Buffer pGeometries() {
        return VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address());
    }

    @NativeType(value="VkAccelerationStructureGeometryKHR const * const *")
    public @Nullable PointerBuffer ppGeometries() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address());
    }

    public VkDeviceOrHostAddressKHR scratchData() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address());
    }

    public VkAccelerationStructureBuildGeometryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR sType$Default() {
        return this.sType(1000150000);
    }

    public VkAccelerationStructureBuildGeometryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR flags(@NativeType(value="VkBuildAccelerationStructureFlagsKHR") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR mode(@NativeType(value="VkBuildAccelerationStructureModeKHR") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR srcAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR dstAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR geometryCount(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR pGeometries(@NativeType(value="VkAccelerationStructureGeometryKHR const *") @Nullable VkAccelerationStructureGeometryKHR.Buffer value) {
        VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR ppGeometries(@NativeType(value="VkAccelerationStructureGeometryKHR const * const *") @Nullable PointerBuffer value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR scratchData(VkDeviceOrHostAddressKHR value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR scratchData(Consumer<VkDeviceOrHostAddressKHR> consumer) {
        consumer.accept(this.scratchData());
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR set(int sType, long pNext, int type, int flags, int mode, long srcAccelerationStructure, long dstAccelerationStructure, int geometryCount, @Nullable VkAccelerationStructureGeometryKHR.Buffer pGeometries, @Nullable PointerBuffer ppGeometries, VkDeviceOrHostAddressKHR scratchData) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.flags(flags);
        this.mode(mode);
        this.srcAccelerationStructure(srcAccelerationStructure);
        this.dstAccelerationStructure(dstAccelerationStructure);
        this.geometryCount(geometryCount);
        this.pGeometries(pGeometries);
        this.ppGeometries(ppGeometries);
        this.scratchData(scratchData);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR set(VkAccelerationStructureBuildGeometryInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR malloc() {
        return new VkAccelerationStructureBuildGeometryInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR calloc() {
        return new VkAccelerationStructureBuildGeometryInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAccelerationStructureBuildGeometryInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR create(long address) {
        return new VkAccelerationStructureBuildGeometryInfoKHR(address, null);
    }

    public static @Nullable VkAccelerationStructureBuildGeometryInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureBuildGeometryInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureBuildGeometryInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureBuildGeometryInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureBuildGeometryInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureBuildGeometryInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MODE));
    }

    public static long nsrcAccelerationStructure(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCACCELERATIONSTRUCTURE));
    }

    public static long ndstAccelerationStructure(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTACCELERATIONSTRUCTURE));
    }

    public static int ngeometryCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GEOMETRYCOUNT));
    }

    public static @Nullable VkAccelerationStructureGeometryKHR.Buffer npGeometries(long struct) {
        return VkAccelerationStructureGeometryKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PGEOMETRIES)), VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(struct));
    }

    public static @Nullable PointerBuffer nppGeometries(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPGEOMETRIES)), (int)VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(struct));
    }

    public static VkDeviceOrHostAddressKHR nscratchData(long struct) {
        return VkDeviceOrHostAddressKHR.create(struct + (long)SCRATCHDATA);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MODE), (int)value);
    }

    public static void nsrcAccelerationStructure(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCACCELERATIONSTRUCTURE), (long)value);
    }

    public static void ndstAccelerationStructure(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTACCELERATIONSTRUCTURE), (long)value);
    }

    public static void ngeometryCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GEOMETRYCOUNT), (int)value);
    }

    public static void npGeometries(long struct, @Nullable VkAccelerationStructureGeometryKHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PGEOMETRIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nppGeometries(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPGEOMETRIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nscratchData(long struct, VkDeviceOrHostAddressKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCRATCHDATA), (long)VkDeviceOrHostAddressKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureBuildGeometryInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkAccelerationStructureBuildGeometryInfoKHR.__member((int)4), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)POINTER_SIZE), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)4), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)4), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)4), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)8), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)8), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)4), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)POINTER_SIZE), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)POINTER_SIZE), VkAccelerationStructureBuildGeometryInfoKHR.__member((int)VkDeviceOrHostAddressKHR.SIZEOF, (int)VkDeviceOrHostAddressKHR.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        MODE = layout.offsetof(4);
        SRCACCELERATIONSTRUCTURE = layout.offsetof(5);
        DSTACCELERATIONSTRUCTURE = layout.offsetof(6);
        GEOMETRYCOUNT = layout.offsetof(7);
        PGEOMETRIES = layout.offsetof(8);
        PPGEOMETRIES = layout.offsetof(9);
        SCRATCHDATA = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureBuildGeometryInfoKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureBuildGeometryInfoKHR ELEMENT_FACTORY = VkAccelerationStructureBuildGeometryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkAccelerationStructureBuildGeometryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureTypeKHR")
        public int type() {
            return VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address());
        }

        @NativeType(value="VkBuildAccelerationStructureFlagsKHR")
        public int flags() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkBuildAccelerationStructureModeKHR")
        public int mode() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long srcAccelerationStructure() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long dstAccelerationStructure() {
            return VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address());
        }

        @NativeType(value="uint32_t")
        public int geometryCount() {
            return VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address());
        }

        @NativeType(value="VkAccelerationStructureGeometryKHR const *")
        public @Nullable VkAccelerationStructureGeometryKHR.Buffer pGeometries() {
            return VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address());
        }

        @NativeType(value="VkAccelerationStructureGeometryKHR const * const *")
        public @Nullable PointerBuffer ppGeometries() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address());
        }

        public VkDeviceOrHostAddressKHR scratchData() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBuildAccelerationStructureFlagsKHR") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkBuildAccelerationStructureModeKHR") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address(), value);
            return this;
        }

        public Buffer srcAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address(), value);
            return this;
        }

        public Buffer dstAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address(), value);
            return this;
        }

        public Buffer geometryCount(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address(), value);
            return this;
        }

        public Buffer pGeometries(@NativeType(value="VkAccelerationStructureGeometryKHR const *") @Nullable VkAccelerationStructureGeometryKHR.Buffer value) {
            VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address(), value);
            return this;
        }

        public Buffer ppGeometries(@NativeType(value="VkAccelerationStructureGeometryKHR const * const *") @Nullable PointerBuffer value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address(), value);
            return this;
        }

        public Buffer scratchData(VkDeviceOrHostAddressKHR value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address(), value);
            return this;
        }

        public Buffer scratchData(Consumer<VkDeviceOrHostAddressKHR> consumer) {
            consumer.accept(this.scratchData());
            return this;
        }
    }
}

