/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryAabbsDataKHR;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryInstancesDataKHR;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryTrianglesDataKHR;

public class VkAccelerationStructureGeometryDataKHR
extends Struct<VkAccelerationStructureGeometryDataKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRIANGLES;
    public static final int AABBS;
    public static final int INSTANCES;

    protected VkAccelerationStructureGeometryDataKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAccelerationStructureGeometryDataKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureGeometryDataKHR(address, container);
    }

    public VkAccelerationStructureGeometryDataKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureGeometryDataKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkAccelerationStructureGeometryTrianglesDataKHR triangles() {
        return VkAccelerationStructureGeometryDataKHR.ntriangles(this.address());
    }

    public VkAccelerationStructureGeometryAabbsDataKHR aabbs() {
        return VkAccelerationStructureGeometryDataKHR.naabbs(this.address());
    }

    public VkAccelerationStructureGeometryInstancesDataKHR instances() {
        return VkAccelerationStructureGeometryDataKHR.ninstances(this.address());
    }

    public VkAccelerationStructureGeometryDataKHR triangles(VkAccelerationStructureGeometryTrianglesDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.ntriangles(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR triangles(Consumer<VkAccelerationStructureGeometryTrianglesDataKHR> consumer) {
        consumer.accept(this.triangles());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR aabbs(VkAccelerationStructureGeometryAabbsDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.naabbs(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR aabbs(Consumer<VkAccelerationStructureGeometryAabbsDataKHR> consumer) {
        consumer.accept(this.aabbs());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR instances(VkAccelerationStructureGeometryInstancesDataKHR value) {
        VkAccelerationStructureGeometryDataKHR.ninstances(this.address(), value);
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR instances(Consumer<VkAccelerationStructureGeometryInstancesDataKHR> consumer) {
        consumer.accept(this.instances());
        return this;
    }

    public VkAccelerationStructureGeometryDataKHR set(VkAccelerationStructureGeometryDataKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureGeometryDataKHR malloc() {
        return new VkAccelerationStructureGeometryDataKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAccelerationStructureGeometryDataKHR calloc() {
        return new VkAccelerationStructureGeometryDataKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAccelerationStructureGeometryDataKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAccelerationStructureGeometryDataKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAccelerationStructureGeometryDataKHR create(long address) {
        return new VkAccelerationStructureGeometryDataKHR(address, null);
    }

    public static @Nullable VkAccelerationStructureGeometryDataKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureGeometryDataKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureGeometryDataKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureGeometryDataKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureGeometryDataKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureGeometryDataKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureGeometryDataKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureGeometryDataKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkAccelerationStructureGeometryTrianglesDataKHR ntriangles(long struct) {
        return VkAccelerationStructureGeometryTrianglesDataKHR.create(struct + (long)TRIANGLES);
    }

    public static VkAccelerationStructureGeometryAabbsDataKHR naabbs(long struct) {
        return VkAccelerationStructureGeometryAabbsDataKHR.create(struct + (long)AABBS);
    }

    public static VkAccelerationStructureGeometryInstancesDataKHR ninstances(long struct) {
        return VkAccelerationStructureGeometryInstancesDataKHR.create(struct + (long)INSTANCES);
    }

    public static void ntriangles(long struct, VkAccelerationStructureGeometryTrianglesDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TRIANGLES), (long)VkAccelerationStructureGeometryTrianglesDataKHR.SIZEOF);
    }

    public static void naabbs(long struct, VkAccelerationStructureGeometryAabbsDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)AABBS), (long)VkAccelerationStructureGeometryAabbsDataKHR.SIZEOF);
    }

    public static void ninstances(long struct, VkAccelerationStructureGeometryInstancesDataKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INSTANCES), (long)VkAccelerationStructureGeometryInstancesDataKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureGeometryDataKHR.__union((Struct.Member[])new Struct.Member[]{VkAccelerationStructureGeometryDataKHR.__member((int)VkAccelerationStructureGeometryTrianglesDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryTrianglesDataKHR.ALIGNOF), VkAccelerationStructureGeometryDataKHR.__member((int)VkAccelerationStructureGeometryAabbsDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryAabbsDataKHR.ALIGNOF), VkAccelerationStructureGeometryDataKHR.__member((int)VkAccelerationStructureGeometryInstancesDataKHR.SIZEOF, (int)VkAccelerationStructureGeometryInstancesDataKHR.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRIANGLES = layout.offsetof(0);
        AABBS = layout.offsetof(1);
        INSTANCES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureGeometryDataKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureGeometryDataKHR ELEMENT_FACTORY = VkAccelerationStructureGeometryDataKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkAccelerationStructureGeometryDataKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkAccelerationStructureGeometryTrianglesDataKHR triangles() {
            return VkAccelerationStructureGeometryDataKHR.ntriangles(this.address());
        }

        public VkAccelerationStructureGeometryAabbsDataKHR aabbs() {
            return VkAccelerationStructureGeometryDataKHR.naabbs(this.address());
        }

        public VkAccelerationStructureGeometryInstancesDataKHR instances() {
            return VkAccelerationStructureGeometryDataKHR.ninstances(this.address());
        }

        public Buffer triangles(VkAccelerationStructureGeometryTrianglesDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.ntriangles(this.address(), value);
            return this;
        }

        public Buffer triangles(Consumer<VkAccelerationStructureGeometryTrianglesDataKHR> consumer) {
            consumer.accept(this.triangles());
            return this;
        }

        public Buffer aabbs(VkAccelerationStructureGeometryAabbsDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.naabbs(this.address(), value);
            return this;
        }

        public Buffer aabbs(Consumer<VkAccelerationStructureGeometryAabbsDataKHR> consumer) {
            consumer.accept(this.aabbs());
            return this;
        }

        public Buffer instances(VkAccelerationStructureGeometryInstancesDataKHR value) {
            VkAccelerationStructureGeometryDataKHR.ninstances(this.address(), value);
            return this;
        }

        public Buffer instances(Consumer<VkAccelerationStructureGeometryInstancesDataKHR> consumer) {
            consumer.accept(this.instances());
            return this;
        }
    }
}

