/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentReference
extends Struct<VkAttachmentReference>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENT;
    public static final int LAYOUT;

    protected VkAttachmentReference(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAttachmentReference create(long address, @Nullable ByteBuffer container) {
        return new VkAttachmentReference(address, container);
    }

    public VkAttachmentReference(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAttachmentReference.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int attachment() {
        return VkAttachmentReference.nattachment(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int layout() {
        return VkAttachmentReference.nlayout(this.address());
    }

    public VkAttachmentReference attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference.nattachment(this.address(), value);
        return this;
    }

    public VkAttachmentReference layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference.nlayout(this.address(), value);
        return this;
    }

    public VkAttachmentReference set(int attachment, int layout) {
        this.attachment(attachment);
        this.layout(layout);
        return this;
    }

    public VkAttachmentReference set(VkAttachmentReference src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAttachmentReference malloc() {
        return new VkAttachmentReference(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAttachmentReference calloc() {
        return new VkAttachmentReference(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAttachmentReference create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAttachmentReference(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAttachmentReference create(long address) {
        return new VkAttachmentReference(address, null);
    }

    public static @Nullable VkAttachmentReference createSafe(long address) {
        return address == 0L ? null : new VkAttachmentReference(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAttachmentReference.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentReference.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkAttachmentReference mallocStack() {
        return VkAttachmentReference.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentReference callocStack() {
        return VkAttachmentReference.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentReference mallocStack(MemoryStack stack) {
        return VkAttachmentReference.malloc(stack);
    }

    @Deprecated
    public static VkAttachmentReference callocStack(MemoryStack stack) {
        return VkAttachmentReference.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference.calloc(capacity, stack);
    }

    public static VkAttachmentReference malloc(MemoryStack stack) {
        return new VkAttachmentReference(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAttachmentReference calloc(MemoryStack stack) {
        return new VkAttachmentReference(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nattachment(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHMENT));
    }

    public static int nlayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LAYOUT));
    }

    public static void nattachment(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHMENT), (int)value);
    }

    public static void nlayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LAYOUT), (int)value);
    }

    static {
        Struct.Layout layout = VkAttachmentReference.__struct((Struct.Member[])new Struct.Member[]{VkAttachmentReference.__member((int)4), VkAttachmentReference.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENT = layout.offsetof(0);
        LAYOUT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentReference, Buffer>
    implements NativeResource {
        private static final VkAttachmentReference ELEMENT_FACTORY = VkAttachmentReference.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkAttachmentReference getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int attachment() {
            return VkAttachmentReference.nattachment(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int layout() {
            return VkAttachmentReference.nlayout(this.address());
        }

        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference.nattachment(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference.nlayout(this.address(), value);
            return this;
        }
    }
}

