/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceGroupBindSparseInfo;
import org.lwjgl.vulkan.VkDeviceGroupBindSparseInfoKHR;
import org.lwjgl.vulkan.VkFrameBoundaryEXT;
import org.lwjgl.vulkan.VkSparseBufferMemoryBindInfo;
import org.lwjgl.vulkan.VkSparseImageMemoryBindInfo;
import org.lwjgl.vulkan.VkSparseImageOpaqueMemoryBindInfo;
import org.lwjgl.vulkan.VkTimelineSemaphoreSubmitInfo;
import org.lwjgl.vulkan.VkTimelineSemaphoreSubmitInfoKHR;

public class VkBindSparseInfo
extends Struct<VkBindSparseInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int BUFFERBINDCOUNT;
    public static final int PBUFFERBINDS;
    public static final int IMAGEOPAQUEBINDCOUNT;
    public static final int PIMAGEOPAQUEBINDS;
    public static final int IMAGEBINDCOUNT;
    public static final int PIMAGEBINDS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHORES;

    protected VkBindSparseInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBindSparseInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBindSparseInfo(address, container);
    }

    public VkBindSparseInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindSparseInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindSparseInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindSparseInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkBindSparseInfo.nwaitSemaphoreCount(this.address());
    }

    @NativeType(value="VkSemaphore const *")
    public @Nullable LongBuffer pWaitSemaphores() {
        return VkBindSparseInfo.npWaitSemaphores(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferBindCount() {
        return VkBindSparseInfo.nbufferBindCount(this.address());
    }

    @NativeType(value="VkSparseBufferMemoryBindInfo const *")
    public @Nullable VkSparseBufferMemoryBindInfo.Buffer pBufferBinds() {
        return VkBindSparseInfo.npBufferBinds(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageOpaqueBindCount() {
        return VkBindSparseInfo.nimageOpaqueBindCount(this.address());
    }

    @NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *")
    public @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer pImageOpaqueBinds() {
        return VkBindSparseInfo.npImageOpaqueBinds(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageBindCount() {
        return VkBindSparseInfo.nimageBindCount(this.address());
    }

    @NativeType(value="VkSparseImageMemoryBindInfo const *")
    public @Nullable VkSparseImageMemoryBindInfo.Buffer pImageBinds() {
        return VkBindSparseInfo.npImageBinds(this.address());
    }

    @NativeType(value="uint32_t")
    public int signalSemaphoreCount() {
        return VkBindSparseInfo.nsignalSemaphoreCount(this.address());
    }

    @NativeType(value="VkSemaphore const *")
    public @Nullable LongBuffer pSignalSemaphores() {
        return VkBindSparseInfo.npSignalSemaphores(this.address());
    }

    public VkBindSparseInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindSparseInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindSparseInfo sType$Default() {
        return this.sType(7);
    }

    public VkBindSparseInfo pNext(@NativeType(value="void const *") long value) {
        VkBindSparseInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pNext(VkDeviceGroupBindSparseInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindSparseInfo pNext(VkDeviceGroupBindSparseInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindSparseInfo pNext(VkFrameBoundaryEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindSparseInfo pNext(VkTimelineSemaphoreSubmitInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindSparseInfo pNext(VkTimelineSemaphoreSubmitInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindSparseInfo pWaitSemaphores(@NativeType(value="VkSemaphore const *") @Nullable LongBuffer value) {
        VkBindSparseInfo.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pBufferBinds(@NativeType(value="VkSparseBufferMemoryBindInfo const *") @Nullable VkSparseBufferMemoryBindInfo.Buffer value) {
        VkBindSparseInfo.npBufferBinds(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pImageOpaqueBinds(@NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *") @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer value) {
        VkBindSparseInfo.npImageOpaqueBinds(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pImageBinds(@NativeType(value="VkSparseImageMemoryBindInfo const *") @Nullable VkSparseImageMemoryBindInfo.Buffer value) {
        VkBindSparseInfo.npImageBinds(this.address(), value);
        return this;
    }

    public VkBindSparseInfo pSignalSemaphores(@NativeType(value="VkSemaphore const *") @Nullable LongBuffer value) {
        VkBindSparseInfo.npSignalSemaphores(this.address(), value);
        return this;
    }

    public VkBindSparseInfo set(int sType, long pNext, @Nullable LongBuffer pWaitSemaphores, @Nullable VkSparseBufferMemoryBindInfo.Buffer pBufferBinds, @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer pImageOpaqueBinds, @Nullable VkSparseImageMemoryBindInfo.Buffer pImageBinds, @Nullable LongBuffer pSignalSemaphores) {
        this.sType(sType);
        this.pNext(pNext);
        this.pWaitSemaphores(pWaitSemaphores);
        this.pBufferBinds(pBufferBinds);
        this.pImageOpaqueBinds(pImageOpaqueBinds);
        this.pImageBinds(pImageBinds);
        this.pSignalSemaphores(pSignalSemaphores);
        return this;
    }

    public VkBindSparseInfo set(VkBindSparseInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindSparseInfo malloc() {
        return new VkBindSparseInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindSparseInfo calloc() {
        return new VkBindSparseInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindSparseInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindSparseInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindSparseInfo create(long address) {
        return new VkBindSparseInfo(address, null);
    }

    public static @Nullable VkBindSparseInfo createSafe(long address) {
        return address == 0L ? null : new VkBindSparseInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindSparseInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindSparseInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindSparseInfo mallocStack() {
        return VkBindSparseInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindSparseInfo callocStack() {
        return VkBindSparseInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindSparseInfo mallocStack(MemoryStack stack) {
        return VkBindSparseInfo.malloc(stack);
    }

    @Deprecated
    public static VkBindSparseInfo callocStack(MemoryStack stack) {
        return VkBindSparseInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindSparseInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindSparseInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindSparseInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindSparseInfo.calloc(capacity, stack);
    }

    public static VkBindSparseInfo malloc(MemoryStack stack) {
        return new VkBindSparseInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindSparseInfo calloc(MemoryStack stack) {
        return new VkBindSparseInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nwaitSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WAITSEMAPHORECOUNT));
    }

    public static @Nullable LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHORES)), (int)VkBindSparseInfo.nwaitSemaphoreCount(struct));
    }

    public static int nbufferBindCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERBINDCOUNT));
    }

    public static @Nullable VkSparseBufferMemoryBindInfo.Buffer npBufferBinds(long struct) {
        return VkSparseBufferMemoryBindInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERBINDS)), VkBindSparseInfo.nbufferBindCount(struct));
    }

    public static int nimageOpaqueBindCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGEOPAQUEBINDCOUNT));
    }

    public static @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer npImageOpaqueBinds(long struct) {
        return VkSparseImageOpaqueMemoryBindInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEOPAQUEBINDS)), VkBindSparseInfo.nimageOpaqueBindCount(struct));
    }

    public static int nimageBindCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGEBINDCOUNT));
    }

    public static @Nullable VkSparseImageMemoryBindInfo.Buffer npImageBinds(long struct) {
        return VkSparseImageMemoryBindInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEBINDS)), VkBindSparseInfo.nimageBindCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIGNALSEMAPHORECOUNT));
    }

    public static @Nullable LongBuffer npSignalSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PSIGNALSEMAPHORES)), (int)VkBindSparseInfo.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WAITSEMAPHORECOUNT), (int)value);
    }

    public static void npWaitSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWAITSEMAPHORES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkBindSparseInfo.nwaitSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nbufferBindCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERBINDCOUNT), (int)value);
    }

    public static void npBufferBinds(long struct, @Nullable VkSparseBufferMemoryBindInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBUFFERBINDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkBindSparseInfo.nbufferBindCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nimageOpaqueBindCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGEOPAQUEBINDCOUNT), (int)value);
    }

    public static void npImageOpaqueBinds(long struct, @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIMAGEOPAQUEBINDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkBindSparseInfo.nimageOpaqueBindCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nimageBindCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGEBINDCOUNT), (int)value);
    }

    public static void npImageBinds(long struct, @Nullable VkSparseImageMemoryBindInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIMAGEBINDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkBindSparseInfo.nimageBindCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIGNALSEMAPHORECOUNT), (int)value);
    }

    public static void npSignalSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSIGNALSEMAPHORES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkBindSparseInfo.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int imageBindCount;
        int imageOpaqueBindCount;
        int bufferBindCount;
        if (VkBindSparseInfo.nwaitSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHORES)));
        }
        if ((bufferBindCount = VkBindSparseInfo.nbufferBindCount(struct)) != 0) {
            long pBufferBinds = MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERBINDS));
            Checks.check((long)pBufferBinds);
            VkBindSparseInfo.validate((long)pBufferBinds, (int)bufferBindCount, (int)VkSparseBufferMemoryBindInfo.SIZEOF, VkSparseBufferMemoryBindInfo::validate);
        }
        if ((imageOpaqueBindCount = VkBindSparseInfo.nimageOpaqueBindCount(struct)) != 0) {
            long pImageOpaqueBinds = MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEOPAQUEBINDS));
            Checks.check((long)pImageOpaqueBinds);
            VkBindSparseInfo.validate((long)pImageOpaqueBinds, (int)imageOpaqueBindCount, (int)VkSparseImageOpaqueMemoryBindInfo.SIZEOF, VkSparseImageOpaqueMemoryBindInfo::validate);
        }
        if ((imageBindCount = VkBindSparseInfo.nimageBindCount(struct)) != 0) {
            long pImageBinds = MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEBINDS));
            Checks.check((long)pImageBinds);
            VkBindSparseInfo.validate((long)pImageBinds, (int)imageBindCount, (int)VkSparseImageMemoryBindInfo.SIZEOF, VkSparseImageMemoryBindInfo::validate);
        }
        if (VkBindSparseInfo.nsignalSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSIGNALSEMAPHORES)));
        }
    }

    static {
        Struct.Layout layout = VkBindSparseInfo.__struct((Struct.Member[])new Struct.Member[]{VkBindSparseInfo.__member((int)4), VkBindSparseInfo.__member((int)POINTER_SIZE), VkBindSparseInfo.__member((int)4), VkBindSparseInfo.__member((int)POINTER_SIZE), VkBindSparseInfo.__member((int)4), VkBindSparseInfo.__member((int)POINTER_SIZE), VkBindSparseInfo.__member((int)4), VkBindSparseInfo.__member((int)POINTER_SIZE), VkBindSparseInfo.__member((int)4), VkBindSparseInfo.__member((int)POINTER_SIZE), VkBindSparseInfo.__member((int)4), VkBindSparseInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        BUFFERBINDCOUNT = layout.offsetof(4);
        PBUFFERBINDS = layout.offsetof(5);
        IMAGEOPAQUEBINDCOUNT = layout.offsetof(6);
        PIMAGEOPAQUEBINDS = layout.offsetof(7);
        IMAGEBINDCOUNT = layout.offsetof(8);
        PIMAGEBINDS = layout.offsetof(9);
        SIGNALSEMAPHORECOUNT = layout.offsetof(10);
        PSIGNALSEMAPHORES = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkBindSparseInfo, Buffer>
    implements NativeResource {
        private static final VkBindSparseInfo ELEMENT_FACTORY = VkBindSparseInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBindSparseInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindSparseInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindSparseInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkBindSparseInfo.nwaitSemaphoreCount(this.address());
        }

        @NativeType(value="VkSemaphore const *")
        public @Nullable LongBuffer pWaitSemaphores() {
            return VkBindSparseInfo.npWaitSemaphores(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferBindCount() {
            return VkBindSparseInfo.nbufferBindCount(this.address());
        }

        @NativeType(value="VkSparseBufferMemoryBindInfo const *")
        public @Nullable VkSparseBufferMemoryBindInfo.Buffer pBufferBinds() {
            return VkBindSparseInfo.npBufferBinds(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageOpaqueBindCount() {
            return VkBindSparseInfo.nimageOpaqueBindCount(this.address());
        }

        @NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *")
        public @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer pImageOpaqueBinds() {
            return VkBindSparseInfo.npImageOpaqueBinds(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageBindCount() {
            return VkBindSparseInfo.nimageBindCount(this.address());
        }

        @NativeType(value="VkSparseImageMemoryBindInfo const *")
        public @Nullable VkSparseImageMemoryBindInfo.Buffer pImageBinds() {
            return VkBindSparseInfo.npImageBinds(this.address());
        }

        @NativeType(value="uint32_t")
        public int signalSemaphoreCount() {
            return VkBindSparseInfo.nsignalSemaphoreCount(this.address());
        }

        @NativeType(value="VkSemaphore const *")
        public @Nullable LongBuffer pSignalSemaphores() {
            return VkBindSparseInfo.npSignalSemaphores(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindSparseInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(7);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindSparseInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceGroupBindSparseInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceGroupBindSparseInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkFrameBoundaryEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkTimelineSemaphoreSubmitInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkTimelineSemaphoreSubmitInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pWaitSemaphores(@NativeType(value="VkSemaphore const *") @Nullable LongBuffer value) {
            VkBindSparseInfo.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer pBufferBinds(@NativeType(value="VkSparseBufferMemoryBindInfo const *") @Nullable VkSparseBufferMemoryBindInfo.Buffer value) {
            VkBindSparseInfo.npBufferBinds(this.address(), value);
            return this;
        }

        public Buffer pImageOpaqueBinds(@NativeType(value="VkSparseImageOpaqueMemoryBindInfo const *") @Nullable VkSparseImageOpaqueMemoryBindInfo.Buffer value) {
            VkBindSparseInfo.npImageOpaqueBinds(this.address(), value);
            return this;
        }

        public Buffer pImageBinds(@NativeType(value="VkSparseImageMemoryBindInfo const *") @Nullable VkSparseImageMemoryBindInfo.Buffer value) {
            VkBindSparseInfo.npImageBinds(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphores(@NativeType(value="VkSemaphore const *") @Nullable LongBuffer value) {
            VkBindSparseInfo.npSignalSemaphores(this.address(), value);
            return this;
        }
    }
}

