/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindVertexBufferIndirectCommandEXT
extends Struct<VkBindVertexBufferIndirectCommandEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERADDRESS;
    public static final int SIZE;
    public static final int STRIDE;

    protected VkBindVertexBufferIndirectCommandEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBindVertexBufferIndirectCommandEXT create(long address, @Nullable ByteBuffer container) {
        return new VkBindVertexBufferIndirectCommandEXT(address, container);
    }

    public VkBindVertexBufferIndirectCommandEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindVertexBufferIndirectCommandEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long bufferAddress() {
        return VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkBindVertexBufferIndirectCommandEXT.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int stride() {
        return VkBindVertexBufferIndirectCommandEXT.nstride(this.address());
    }

    public VkBindVertexBufferIndirectCommandEXT bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT size(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandEXT.nsize(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT stride(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandEXT.nstride(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT set(long bufferAddress, int size, int stride) {
        this.bufferAddress(bufferAddress);
        this.size(size);
        this.stride(stride);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT set(VkBindVertexBufferIndirectCommandEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindVertexBufferIndirectCommandEXT malloc() {
        return new VkBindVertexBufferIndirectCommandEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindVertexBufferIndirectCommandEXT calloc() {
        return new VkBindVertexBufferIndirectCommandEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindVertexBufferIndirectCommandEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindVertexBufferIndirectCommandEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindVertexBufferIndirectCommandEXT create(long address) {
        return new VkBindVertexBufferIndirectCommandEXT(address, null);
    }

    public static @Nullable VkBindVertexBufferIndirectCommandEXT createSafe(long address) {
        return address == 0L ? null : new VkBindVertexBufferIndirectCommandEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindVertexBufferIndirectCommandEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindVertexBufferIndirectCommandEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindVertexBufferIndirectCommandEXT malloc(MemoryStack stack) {
        return new VkBindVertexBufferIndirectCommandEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindVertexBufferIndirectCommandEXT calloc(MemoryStack stack) {
        return new VkBindVertexBufferIndirectCommandEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferAddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUFFERADDRESS));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static int nstride(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STRIDE));
    }

    public static void nbufferAddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BUFFERADDRESS), (long)value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void nstride(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STRIDE), (int)value);
    }

    static {
        Struct.Layout layout = VkBindVertexBufferIndirectCommandEXT.__struct((Struct.Member[])new Struct.Member[]{VkBindVertexBufferIndirectCommandEXT.__member((int)8), VkBindVertexBufferIndirectCommandEXT.__member((int)4), VkBindVertexBufferIndirectCommandEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERADDRESS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindVertexBufferIndirectCommandEXT, Buffer>
    implements NativeResource {
        private static final VkBindVertexBufferIndirectCommandEXT ELEMENT_FACTORY = VkBindVertexBufferIndirectCommandEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBindVertexBufferIndirectCommandEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long bufferAddress() {
            return VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkBindVertexBufferIndirectCommandEXT.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int stride() {
            return VkBindVertexBufferIndirectCommandEXT.nstride(this.address());
        }

        public Buffer bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandEXT.nsize(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandEXT.nstride(this.address(), value);
            return this;
        }
    }
}

