/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkBufferImageCopy
extends Struct<VkBufferImageCopy>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFEROFFSET;
    public static final int BUFFERROWLENGTH;
    public static final int BUFFERIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkBufferImageCopy(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBufferImageCopy create(long address, @Nullable ByteBuffer container) {
        return new VkBufferImageCopy(address, container);
    }

    public VkBufferImageCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferImageCopy.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long bufferOffset() {
        return VkBufferImageCopy.nbufferOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferRowLength() {
        return VkBufferImageCopy.nbufferRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferImageHeight() {
        return VkBufferImageCopy.nbufferImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkBufferImageCopy.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkBufferImageCopy.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkBufferImageCopy.nimageExtent(this.address());
    }

    public VkBufferImageCopy bufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferImageCopy.nbufferOffset(this.address(), value);
        return this;
    }

    public VkBufferImageCopy bufferRowLength(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy.nbufferRowLength(this.address(), value);
        return this;
    }

    public VkBufferImageCopy bufferImageHeight(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy.nbufferImageHeight(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageSubresource(VkImageSubresourceLayers value) {
        VkBufferImageCopy.nimageSubresource(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkBufferImageCopy imageOffset(VkOffset3D value) {
        VkBufferImageCopy.nimageOffset(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkBufferImageCopy imageExtent(VkExtent3D value) {
        VkBufferImageCopy.nimageExtent(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkBufferImageCopy set(long bufferOffset, int bufferRowLength, int bufferImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.bufferOffset(bufferOffset);
        this.bufferRowLength(bufferRowLength);
        this.bufferImageHeight(bufferImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkBufferImageCopy set(VkBufferImageCopy src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferImageCopy malloc() {
        return new VkBufferImageCopy(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBufferImageCopy calloc() {
        return new VkBufferImageCopy(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBufferImageCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBufferImageCopy(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBufferImageCopy create(long address) {
        return new VkBufferImageCopy(address, null);
    }

    public static @Nullable VkBufferImageCopy createSafe(long address) {
        return address == 0L ? null : new VkBufferImageCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBufferImageCopy.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferImageCopy.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBufferImageCopy mallocStack() {
        return VkBufferImageCopy.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferImageCopy callocStack() {
        return VkBufferImageCopy.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferImageCopy mallocStack(MemoryStack stack) {
        return VkBufferImageCopy.malloc(stack);
    }

    @Deprecated
    public static VkBufferImageCopy callocStack(MemoryStack stack) {
        return VkBufferImageCopy.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferImageCopy.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferImageCopy.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferImageCopy.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferImageCopy.calloc(capacity, stack);
    }

    public static VkBufferImageCopy malloc(MemoryStack stack) {
        return new VkBufferImageCopy(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferImageCopy calloc(MemoryStack stack) {
        return new VkBufferImageCopy(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferOffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUFFEROFFSET));
    }

    public static int nbufferRowLength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERROWLENGTH));
    }

    public static int nbufferImageHeight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERIMAGEHEIGHT));
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nbufferOffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BUFFEROFFSET), (long)value);
    }

    public static void nbufferRowLength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERROWLENGTH), (int)value);
    }

    public static void nbufferImageHeight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERIMAGEHEIGHT), (int)value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGESUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEEXTENT), (long)VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkBufferImageCopy.__struct((Struct.Member[])new Struct.Member[]{VkBufferImageCopy.__member((int)8), VkBufferImageCopy.__member((int)4), VkBufferImageCopy.__member((int)4), VkBufferImageCopy.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkBufferImageCopy.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkBufferImageCopy.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFEROFFSET = layout.offsetof(0);
        BUFFERROWLENGTH = layout.offsetof(1);
        BUFFERIMAGEHEIGHT = layout.offsetof(2);
        IMAGESUBRESOURCE = layout.offsetof(3);
        IMAGEOFFSET = layout.offsetof(4);
        IMAGEEXTENT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkBufferImageCopy, Buffer>
    implements NativeResource {
        private static final VkBufferImageCopy ELEMENT_FACTORY = VkBufferImageCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBufferImageCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long bufferOffset() {
            return VkBufferImageCopy.nbufferOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferRowLength() {
            return VkBufferImageCopy.nbufferRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferImageHeight() {
            return VkBufferImageCopy.nbufferImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkBufferImageCopy.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkBufferImageCopy.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkBufferImageCopy.nimageExtent(this.address());
        }

        public Buffer bufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferImageCopy.nbufferOffset(this.address(), value);
            return this;
        }

        public Buffer bufferRowLength(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy.nbufferRowLength(this.address(), value);
            return this;
        }

        public Buffer bufferImageHeight(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy.nbufferImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkBufferImageCopy.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkBufferImageCopy.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkBufferImageCopy.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

