/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryAcquireUnmodifiedEXT;

public class VkBufferMemoryBarrier
extends Struct<VkBufferMemoryBarrier>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkBufferMemoryBarrier(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBufferMemoryBarrier create(long address, @Nullable ByteBuffer container) {
        return new VkBufferMemoryBarrier(address, container);
    }

    public VkBufferMemoryBarrier(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferMemoryBarrier.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferMemoryBarrier.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferMemoryBarrier.npNext(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int srcAccessMask() {
        return VkBufferMemoryBarrier.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int dstAccessMask() {
        return VkBufferMemoryBarrier.ndstAccessMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcQueueFamilyIndex() {
        return VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstQueueFamilyIndex() {
        return VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferMemoryBarrier.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkBufferMemoryBarrier.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferMemoryBarrier.nsize(this.address());
    }

    public VkBufferMemoryBarrier sType(@NativeType(value="VkStructureType") int value) {
        VkBufferMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier sType$Default() {
        return this.sType(44);
    }

    public VkBufferMemoryBarrier pNext(@NativeType(value="void const *") long value) {
        VkBufferMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier pNext(VkExternalMemoryAcquireUnmodifiedEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferMemoryBarrier srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkBufferMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkBufferMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferMemoryBarrier.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier offset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferMemoryBarrier.noffset(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferMemoryBarrier.nsize(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long buffer, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkBufferMemoryBarrier set(VkBufferMemoryBarrier src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferMemoryBarrier malloc() {
        return new VkBufferMemoryBarrier(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBufferMemoryBarrier calloc() {
        return new VkBufferMemoryBarrier(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBufferMemoryBarrier create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBufferMemoryBarrier(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBufferMemoryBarrier create(long address) {
        return new VkBufferMemoryBarrier(address, null);
    }

    public static @Nullable VkBufferMemoryBarrier createSafe(long address) {
        return address == 0L ? null : new VkBufferMemoryBarrier(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBufferMemoryBarrier.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferMemoryBarrier.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBufferMemoryBarrier mallocStack() {
        return VkBufferMemoryBarrier.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferMemoryBarrier callocStack() {
        return VkBufferMemoryBarrier.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferMemoryBarrier mallocStack(MemoryStack stack) {
        return VkBufferMemoryBarrier.malloc(stack);
    }

    @Deprecated
    public static VkBufferMemoryBarrier callocStack(MemoryStack stack) {
        return VkBufferMemoryBarrier.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferMemoryBarrier.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferMemoryBarrier.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryBarrier.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryBarrier.calloc(capacity, stack);
    }

    public static VkBufferMemoryBarrier malloc(MemoryStack stack) {
        return new VkBufferMemoryBarrier(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferMemoryBarrier calloc(MemoryStack stack) {
        return new VkBufferMemoryBarrier(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsrcAccessMask(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCACCESSMASK));
    }

    public static int ndstAccessMask(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTACCESSMASK));
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCQUEUEFAMILYINDEX));
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTQUEUEFAMILYINDEX));
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUFFER));
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCACCESSMASK), (int)value);
    }

    public static void ndstAccessMask(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTACCESSMASK), (int)value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCQUEUEFAMILYINDEX), (int)value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTQUEUEFAMILYINDEX), (int)value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BUFFER), (long)value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkBufferMemoryBarrier.__struct((Struct.Member[])new Struct.Member[]{VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)POINTER_SIZE), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)4), VkBufferMemoryBarrier.__member((int)8), VkBufferMemoryBarrier.__member((int)8), VkBufferMemoryBarrier.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
        SRCQUEUEFAMILYINDEX = layout.offsetof(4);
        DSTQUEUEFAMILYINDEX = layout.offsetof(5);
        BUFFER = layout.offsetof(6);
        OFFSET = layout.offsetof(7);
        SIZE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBufferMemoryBarrier, Buffer>
    implements NativeResource {
        private static final VkBufferMemoryBarrier ELEMENT_FACTORY = VkBufferMemoryBarrier.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBufferMemoryBarrier getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferMemoryBarrier.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferMemoryBarrier.npNext(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int srcAccessMask() {
            return VkBufferMemoryBarrier.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int dstAccessMask() {
            return VkBufferMemoryBarrier.ndstAccessMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcQueueFamilyIndex() {
            return VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstQueueFamilyIndex() {
            return VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferMemoryBarrier.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkBufferMemoryBarrier.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferMemoryBarrier.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(44);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExternalMemoryAcquireUnmodifiedEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkBufferMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkBufferMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkBufferMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkBufferMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferMemoryBarrier.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferMemoryBarrier.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferMemoryBarrier.nsize(this.address(), value);
            return this;
        }
    }
}

