/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkClearDepthStencilValue
extends Struct<VkClearDepthStencilValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEPTH;
    public static final int STENCIL;

    protected VkClearDepthStencilValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkClearDepthStencilValue create(long address, @Nullable ByteBuffer container) {
        return new VkClearDepthStencilValue(address, container);
    }

    public VkClearDepthStencilValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearDepthStencilValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float depth() {
        return VkClearDepthStencilValue.ndepth(this.address());
    }

    @NativeType(value="uint32_t")
    public int stencil() {
        return VkClearDepthStencilValue.nstencil(this.address());
    }

    public VkClearDepthStencilValue depth(float value) {
        VkClearDepthStencilValue.ndepth(this.address(), value);
        return this;
    }

    public VkClearDepthStencilValue stencil(@NativeType(value="uint32_t") int value) {
        VkClearDepthStencilValue.nstencil(this.address(), value);
        return this;
    }

    public VkClearDepthStencilValue set(float depth, int stencil) {
        this.depth(depth);
        this.stencil(stencil);
        return this;
    }

    public VkClearDepthStencilValue set(VkClearDepthStencilValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearDepthStencilValue malloc() {
        return new VkClearDepthStencilValue(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkClearDepthStencilValue calloc() {
        return new VkClearDepthStencilValue(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkClearDepthStencilValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkClearDepthStencilValue(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkClearDepthStencilValue create(long address) {
        return new VkClearDepthStencilValue(address, null);
    }

    public static @Nullable VkClearDepthStencilValue createSafe(long address) {
        return address == 0L ? null : new VkClearDepthStencilValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkClearDepthStencilValue.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearDepthStencilValue.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkClearDepthStencilValue mallocStack() {
        return VkClearDepthStencilValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearDepthStencilValue callocStack() {
        return VkClearDepthStencilValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearDepthStencilValue mallocStack(MemoryStack stack) {
        return VkClearDepthStencilValue.malloc(stack);
    }

    @Deprecated
    public static VkClearDepthStencilValue callocStack(MemoryStack stack) {
        return VkClearDepthStencilValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearDepthStencilValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearDepthStencilValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearDepthStencilValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearDepthStencilValue.calloc(capacity, stack);
    }

    public static VkClearDepthStencilValue malloc(MemoryStack stack) {
        return new VkClearDepthStencilValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkClearDepthStencilValue calloc(MemoryStack stack) {
        return new VkClearDepthStencilValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float ndepth(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)DEPTH));
    }

    public static int nstencil(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCIL));
    }

    public static void ndepth(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)DEPTH), (float)value);
    }

    public static void nstencil(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCIL), (int)value);
    }

    static {
        Struct.Layout layout = VkClearDepthStencilValue.__struct((Struct.Member[])new Struct.Member[]{VkClearDepthStencilValue.__member((int)4), VkClearDepthStencilValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEPTH = layout.offsetof(0);
        STENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearDepthStencilValue, Buffer>
    implements NativeResource {
        private static final VkClearDepthStencilValue ELEMENT_FACTORY = VkClearDepthStencilValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkClearDepthStencilValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float depth() {
            return VkClearDepthStencilValue.ndepth(this.address());
        }

        @NativeType(value="uint32_t")
        public int stencil() {
            return VkClearDepthStencilValue.nstencil(this.address());
        }

        public Buffer depth(float value) {
            VkClearDepthStencilValue.ndepth(this.address(), value);
            return this;
        }

        public Buffer stencil(@NativeType(value="uint32_t") int value) {
            VkClearDepthStencilValue.nstencil(this.address(), value);
            return this;
        }
    }
}

