/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkComponentMapping
extends Struct<VkComponentMapping>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    protected VkComponentMapping(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkComponentMapping create(long address, @Nullable ByteBuffer container) {
        return new VkComponentMapping(address, container);
    }

    public VkComponentMapping(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkComponentMapping.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkComponentSwizzle")
    public int r() {
        return VkComponentMapping.nr(this.address());
    }

    @NativeType(value="VkComponentSwizzle")
    public int g() {
        return VkComponentMapping.ng(this.address());
    }

    @NativeType(value="VkComponentSwizzle")
    public int b() {
        return VkComponentMapping.nb(this.address());
    }

    @NativeType(value="VkComponentSwizzle")
    public int a() {
        return VkComponentMapping.na(this.address());
    }

    public VkComponentMapping r(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.nr(this.address(), value);
        return this;
    }

    public VkComponentMapping g(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.ng(this.address(), value);
        return this;
    }

    public VkComponentMapping b(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.nb(this.address(), value);
        return this;
    }

    public VkComponentMapping a(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.na(this.address(), value);
        return this;
    }

    public VkComponentMapping set(int r, int g, int b, int a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public VkComponentMapping set(VkComponentMapping src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkComponentMapping malloc() {
        return new VkComponentMapping(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkComponentMapping calloc() {
        return new VkComponentMapping(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkComponentMapping create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkComponentMapping(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkComponentMapping create(long address) {
        return new VkComponentMapping(address, null);
    }

    public static @Nullable VkComponentMapping createSafe(long address) {
        return address == 0L ? null : new VkComponentMapping(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkComponentMapping.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkComponentMapping.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkComponentMapping mallocStack() {
        return VkComponentMapping.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkComponentMapping callocStack() {
        return VkComponentMapping.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkComponentMapping mallocStack(MemoryStack stack) {
        return VkComponentMapping.malloc(stack);
    }

    @Deprecated
    public static VkComponentMapping callocStack(MemoryStack stack) {
        return VkComponentMapping.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkComponentMapping.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkComponentMapping.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkComponentMapping.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkComponentMapping.calloc(capacity, stack);
    }

    public static VkComponentMapping malloc(MemoryStack stack) {
        return new VkComponentMapping(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkComponentMapping calloc(MemoryStack stack) {
        return new VkComponentMapping(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nr(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)R));
    }

    public static int ng(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)G));
    }

    public static int nb(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)B));
    }

    public static int na(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)A));
    }

    public static void nr(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)R), (int)value);
    }

    public static void ng(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)G), (int)value);
    }

    public static void nb(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)B), (int)value);
    }

    public static void na(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)A), (int)value);
    }

    static {
        Struct.Layout layout = VkComponentMapping.__struct((Struct.Member[])new Struct.Member[]{VkComponentMapping.__member((int)4), VkComponentMapping.__member((int)4), VkComponentMapping.__member((int)4), VkComponentMapping.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkComponentMapping, Buffer>
    implements NativeResource {
        private static final VkComponentMapping ELEMENT_FACTORY = VkComponentMapping.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkComponentMapping getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkComponentSwizzle")
        public int r() {
            return VkComponentMapping.nr(this.address());
        }

        @NativeType(value="VkComponentSwizzle")
        public int g() {
            return VkComponentMapping.ng(this.address());
        }

        @NativeType(value="VkComponentSwizzle")
        public int b() {
            return VkComponentMapping.nb(this.address());
        }

        @NativeType(value="VkComponentSwizzle")
        public int a() {
            return VkComponentMapping.na(this.address());
        }

        public Buffer r(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.nr(this.address(), value);
            return this;
        }

        public Buffer g(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.ng(this.address(), value);
            return this;
        }

        public Buffer b(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.nb(this.address(), value);
            return this;
        }

        public Buffer a(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.na(this.address(), value);
            return this;
        }
    }
}

