/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCopyDescriptorSet
extends Struct<VkCopyDescriptorSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSET;
    public static final int SRCBINDING;
    public static final int SRCARRAYELEMENT;
    public static final int DSTSET;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;

    protected VkCopyDescriptorSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyDescriptorSet create(long address, @Nullable ByteBuffer container) {
        return new VkCopyDescriptorSet(address, container);
    }

    public VkCopyDescriptorSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyDescriptorSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyDescriptorSet.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyDescriptorSet.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSet")
    public long srcSet() {
        return VkCopyDescriptorSet.nsrcSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcBinding() {
        return VkCopyDescriptorSet.nsrcBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcArrayElement() {
        return VkCopyDescriptorSet.nsrcArrayElement(this.address());
    }

    @NativeType(value="VkDescriptorSet")
    public long dstSet() {
        return VkCopyDescriptorSet.ndstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstBinding() {
        return VkCopyDescriptorSet.ndstBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstArrayElement() {
        return VkCopyDescriptorSet.ndstArrayElement(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkCopyDescriptorSet.ndescriptorCount(this.address());
    }

    public VkCopyDescriptorSet sType(@NativeType(value="VkStructureType") int value) {
        VkCopyDescriptorSet.nsType(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet sType$Default() {
        return this.sType(36);
    }

    public VkCopyDescriptorSet pNext(@NativeType(value="void const *") long value) {
        VkCopyDescriptorSet.npNext(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet srcSet(@NativeType(value="VkDescriptorSet") long value) {
        VkCopyDescriptorSet.nsrcSet(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet srcBinding(@NativeType(value="uint32_t") int value) {
        VkCopyDescriptorSet.nsrcBinding(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet srcArrayElement(@NativeType(value="uint32_t") int value) {
        VkCopyDescriptorSet.nsrcArrayElement(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet dstSet(@NativeType(value="VkDescriptorSet") long value) {
        VkCopyDescriptorSet.ndstSet(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet dstBinding(@NativeType(value="uint32_t") int value) {
        VkCopyDescriptorSet.ndstBinding(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet dstArrayElement(@NativeType(value="uint32_t") int value) {
        VkCopyDescriptorSet.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet descriptorCount(@NativeType(value="uint32_t") int value) {
        VkCopyDescriptorSet.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet set(int sType, long pNext, long srcSet, int srcBinding, int srcArrayElement, long dstSet, int dstBinding, int dstArrayElement, int descriptorCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcSet(srcSet);
        this.srcBinding(srcBinding);
        this.srcArrayElement(srcArrayElement);
        this.dstSet(dstSet);
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        return this;
    }

    public VkCopyDescriptorSet set(VkCopyDescriptorSet src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyDescriptorSet malloc() {
        return new VkCopyDescriptorSet(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyDescriptorSet calloc() {
        return new VkCopyDescriptorSet(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyDescriptorSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyDescriptorSet(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyDescriptorSet create(long address) {
        return new VkCopyDescriptorSet(address, null);
    }

    public static @Nullable VkCopyDescriptorSet createSafe(long address) {
        return address == 0L ? null : new VkCopyDescriptorSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyDescriptorSet.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyDescriptorSet.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkCopyDescriptorSet mallocStack() {
        return VkCopyDescriptorSet.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCopyDescriptorSet callocStack() {
        return VkCopyDescriptorSet.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCopyDescriptorSet mallocStack(MemoryStack stack) {
        return VkCopyDescriptorSet.malloc(stack);
    }

    @Deprecated
    public static VkCopyDescriptorSet callocStack(MemoryStack stack) {
        return VkCopyDescriptorSet.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCopyDescriptorSet.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCopyDescriptorSet.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCopyDescriptorSet.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCopyDescriptorSet.calloc(capacity, stack);
    }

    public static VkCopyDescriptorSet malloc(MemoryStack stack) {
        return new VkCopyDescriptorSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyDescriptorSet calloc(MemoryStack stack) {
        return new VkCopyDescriptorSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcSet(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCSET));
    }

    public static int nsrcBinding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCBINDING));
    }

    public static int nsrcArrayElement(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCARRAYELEMENT));
    }

    public static long ndstSet(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTSET));
    }

    public static int ndstBinding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTBINDING));
    }

    public static int ndstArrayElement(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTARRAYELEMENT));
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DESCRIPTORCOUNT));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcSet(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCSET), (long)value);
    }

    public static void nsrcBinding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCBINDING), (int)value);
    }

    public static void nsrcArrayElement(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCARRAYELEMENT), (int)value);
    }

    public static void ndstSet(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTSET), (long)value);
    }

    public static void ndstBinding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTBINDING), (int)value);
    }

    public static void ndstArrayElement(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTARRAYELEMENT), (int)value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DESCRIPTORCOUNT), (int)value);
    }

    static {
        Struct.Layout layout = VkCopyDescriptorSet.__struct((Struct.Member[])new Struct.Member[]{VkCopyDescriptorSet.__member((int)4), VkCopyDescriptorSet.__member((int)POINTER_SIZE), VkCopyDescriptorSet.__member((int)8), VkCopyDescriptorSet.__member((int)4), VkCopyDescriptorSet.__member((int)4), VkCopyDescriptorSet.__member((int)8), VkCopyDescriptorSet.__member((int)4), VkCopyDescriptorSet.__member((int)4), VkCopyDescriptorSet.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSET = layout.offsetof(2);
        SRCBINDING = layout.offsetof(3);
        SRCARRAYELEMENT = layout.offsetof(4);
        DSTSET = layout.offsetof(5);
        DSTBINDING = layout.offsetof(6);
        DSTARRAYELEMENT = layout.offsetof(7);
        DESCRIPTORCOUNT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkCopyDescriptorSet, Buffer>
    implements NativeResource {
        private static final VkCopyDescriptorSet ELEMENT_FACTORY = VkCopyDescriptorSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyDescriptorSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyDescriptorSet.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyDescriptorSet.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSet")
        public long srcSet() {
            return VkCopyDescriptorSet.nsrcSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcBinding() {
            return VkCopyDescriptorSet.nsrcBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcArrayElement() {
            return VkCopyDescriptorSet.nsrcArrayElement(this.address());
        }

        @NativeType(value="VkDescriptorSet")
        public long dstSet() {
            return VkCopyDescriptorSet.ndstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstBinding() {
            return VkCopyDescriptorSet.ndstBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstArrayElement() {
            return VkCopyDescriptorSet.ndstArrayElement(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkCopyDescriptorSet.ndescriptorCount(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyDescriptorSet.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(36);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyDescriptorSet.npNext(this.address(), value);
            return this;
        }

        public Buffer srcSet(@NativeType(value="VkDescriptorSet") long value) {
            VkCopyDescriptorSet.nsrcSet(this.address(), value);
            return this;
        }

        public Buffer srcBinding(@NativeType(value="uint32_t") int value) {
            VkCopyDescriptorSet.nsrcBinding(this.address(), value);
            return this;
        }

        public Buffer srcArrayElement(@NativeType(value="uint32_t") int value) {
            VkCopyDescriptorSet.nsrcArrayElement(this.address(), value);
            return this;
        }

        public Buffer dstSet(@NativeType(value="VkDescriptorSet") long value) {
            VkCopyDescriptorSet.ndstSet(this.address(), value);
            return this;
        }

        public Buffer dstBinding(@NativeType(value="uint32_t") int value) {
            VkCopyDescriptorSet.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(@NativeType(value="uint32_t") int value) {
            VkCopyDescriptorSet.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkCopyDescriptorSet.ndescriptorCount(this.address(), value);
            return this;
        }
    }
}

