/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCopy2;

public class VkCopyImageToImageInfo
extends Struct<VkCopyImageToImageInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyImageToImageInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyImageToImageInfo create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageToImageInfo(address, container);
    }

    public VkCopyImageToImageInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyImageToImageInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyImageToImageInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyImageToImageInfo.npNext(this.address());
    }

    @NativeType(value="VkHostImageCopyFlags")
    public int flags() {
        return VkCopyImageToImageInfo.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkCopyImageToImageInfo.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkCopyImageToImageInfo.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkCopyImageToImageInfo.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkCopyImageToImageInfo.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyImageToImageInfo.nregionCount(this.address());
    }

    @NativeType(value="VkImageCopy2 const *")
    public VkImageCopy2.Buffer pRegions() {
        return VkCopyImageToImageInfo.npRegions(this.address());
    }

    public VkCopyImageToImageInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToImageInfo.nsType(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo sType$Default() {
        return this.sType(1000270007);
    }

    public VkCopyImageToImageInfo pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToImageInfo.npNext(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo flags(@NativeType(value="VkHostImageCopyFlags") int value) {
        VkCopyImageToImageInfo.nflags(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToImageInfo.nsrcImage(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToImageInfo.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo dstImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToImageInfo.ndstImage(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToImageInfo.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
        VkCopyImageToImageInfo.npRegions(this.address(), value);
        return this;
    }

    public VkCopyImageToImageInfo set(int sType, long pNext, int flags, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToImageInfo set(VkCopyImageToImageInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyImageToImageInfo malloc() {
        return new VkCopyImageToImageInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyImageToImageInfo calloc() {
        return new VkCopyImageToImageInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyImageToImageInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyImageToImageInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyImageToImageInfo create(long address) {
        return new VkCopyImageToImageInfo(address, null);
    }

    public static @Nullable VkCopyImageToImageInfo createSafe(long address) {
        return address == 0L ? null : new VkCopyImageToImageInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyImageToImageInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToImageInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageToImageInfo malloc(MemoryStack stack) {
        return new VkCopyImageToImageInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageToImageInfo calloc(MemoryStack stack) {
        return new VkCopyImageToImageInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long nsrcImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCIMAGE));
    }

    public static int nsrcImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCIMAGELAYOUT));
    }

    public static long ndstImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTIMAGE));
    }

    public static int ndstImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTIMAGELAYOUT));
    }

    public static int nregionCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGIONCOUNT));
    }

    public static VkImageCopy2.Buffer npRegions(long struct) {
        return VkImageCopy2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyImageToImageInfo.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nsrcImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCIMAGE), (long)value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCIMAGELAYOUT), (int)value);
    }

    public static void ndstImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTIMAGE), (long)value);
    }

    public static void ndstImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTIMAGELAYOUT), (int)value);
    }

    public static void nregionCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGIONCOUNT), (int)value);
    }

    public static void npRegions(long struct, VkImageCopy2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyImageToImageInfo.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkCopyImageToImageInfo.__struct((Struct.Member[])new Struct.Member[]{VkCopyImageToImageInfo.__member((int)4), VkCopyImageToImageInfo.__member((int)POINTER_SIZE), VkCopyImageToImageInfo.__member((int)4), VkCopyImageToImageInfo.__member((int)8), VkCopyImageToImageInfo.__member((int)4), VkCopyImageToImageInfo.__member((int)8), VkCopyImageToImageInfo.__member((int)4), VkCopyImageToImageInfo.__member((int)4), VkCopyImageToImageInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SRCIMAGE = layout.offsetof(3);
        SRCIMAGELAYOUT = layout.offsetof(4);
        DSTIMAGE = layout.offsetof(5);
        DSTIMAGELAYOUT = layout.offsetof(6);
        REGIONCOUNT = layout.offsetof(7);
        PREGIONS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkCopyImageToImageInfo, Buffer>
    implements NativeResource {
        private static final VkCopyImageToImageInfo ELEMENT_FACTORY = VkCopyImageToImageInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyImageToImageInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyImageToImageInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyImageToImageInfo.npNext(this.address());
        }

        @NativeType(value="VkHostImageCopyFlags")
        public int flags() {
            return VkCopyImageToImageInfo.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkCopyImageToImageInfo.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkCopyImageToImageInfo.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkCopyImageToImageInfo.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkCopyImageToImageInfo.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyImageToImageInfo.nregionCount(this.address());
        }

        @NativeType(value="VkImageCopy2 const *")
        public VkImageCopy2.Buffer pRegions() {
            return VkCopyImageToImageInfo.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToImageInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270007);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToImageInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkHostImageCopyFlags") int value) {
            VkCopyImageToImageInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToImageInfo.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToImageInfo.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToImageInfo.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToImageInfo.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
            VkCopyImageToImageInfo.npRegions(this.address(), value);
            return this;
        }
    }
}

