/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageToMemoryCopy;

public class VkCopyImageToMemoryInfo
extends Struct<VkCopyImageToMemoryInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyImageToMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyImageToMemoryInfo create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageToMemoryInfo(address, container);
    }

    public VkCopyImageToMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyImageToMemoryInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyImageToMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyImageToMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkHostImageCopyFlags")
    public int flags() {
        return VkCopyImageToMemoryInfo.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkCopyImageToMemoryInfo.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkCopyImageToMemoryInfo.nsrcImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyImageToMemoryInfo.nregionCount(this.address());
    }

    @NativeType(value="VkImageToMemoryCopy const *")
    public VkImageToMemoryCopy.Buffer pRegions() {
        return VkCopyImageToMemoryInfo.npRegions(this.address());
    }

    public VkCopyImageToMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfo sType$Default() {
        return this.sType(1000270004);
    }

    public VkCopyImageToMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfo flags(@NativeType(value="VkHostImageCopyFlags") int value) {
        VkCopyImageToMemoryInfo.nflags(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfo srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToMemoryInfo.nsrcImage(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfo srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToMemoryInfo.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfo pRegions(@NativeType(value="VkImageToMemoryCopy const *") VkImageToMemoryCopy.Buffer value) {
        VkCopyImageToMemoryInfo.npRegions(this.address(), value);
        return this;
    }

    public VkCopyImageToMemoryInfo set(int sType, long pNext, int flags, long srcImage, int srcImageLayout, VkImageToMemoryCopy.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToMemoryInfo set(VkCopyImageToMemoryInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyImageToMemoryInfo malloc() {
        return new VkCopyImageToMemoryInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfo calloc() {
        return new VkCopyImageToMemoryInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyImageToMemoryInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyImageToMemoryInfo create(long address) {
        return new VkCopyImageToMemoryInfo(address, null);
    }

    public static @Nullable VkCopyImageToMemoryInfo createSafe(long address) {
        return address == 0L ? null : new VkCopyImageToMemoryInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyImageToMemoryInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToMemoryInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageToMemoryInfo malloc(MemoryStack stack) {
        return new VkCopyImageToMemoryInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfo calloc(MemoryStack stack) {
        return new VkCopyImageToMemoryInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long nsrcImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCIMAGE));
    }

    public static int nsrcImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCIMAGELAYOUT));
    }

    public static int nregionCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGIONCOUNT));
    }

    public static VkImageToMemoryCopy.Buffer npRegions(long struct) {
        return VkImageToMemoryCopy.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyImageToMemoryInfo.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nsrcImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCIMAGE), (long)value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCIMAGELAYOUT), (int)value);
    }

    public static void nregionCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGIONCOUNT), (int)value);
    }

    public static void npRegions(long struct, VkImageToMemoryCopy.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyImageToMemoryInfo.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int regionCount = VkCopyImageToMemoryInfo.nregionCount(struct);
        long pRegions = MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS));
        Checks.check((long)pRegions);
        VkCopyImageToMemoryInfo.validate((long)pRegions, (int)regionCount, (int)VkImageToMemoryCopy.SIZEOF, VkImageToMemoryCopy::validate);
    }

    static {
        Struct.Layout layout = VkCopyImageToMemoryInfo.__struct((Struct.Member[])new Struct.Member[]{VkCopyImageToMemoryInfo.__member((int)4), VkCopyImageToMemoryInfo.__member((int)POINTER_SIZE), VkCopyImageToMemoryInfo.__member((int)4), VkCopyImageToMemoryInfo.__member((int)8), VkCopyImageToMemoryInfo.__member((int)4), VkCopyImageToMemoryInfo.__member((int)4), VkCopyImageToMemoryInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SRCIMAGE = layout.offsetof(3);
        SRCIMAGELAYOUT = layout.offsetof(4);
        REGIONCOUNT = layout.offsetof(5);
        PREGIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkCopyImageToMemoryInfo, Buffer>
    implements NativeResource {
        private static final VkCopyImageToMemoryInfo ELEMENT_FACTORY = VkCopyImageToMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyImageToMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyImageToMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyImageToMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkHostImageCopyFlags")
        public int flags() {
            return VkCopyImageToMemoryInfo.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkCopyImageToMemoryInfo.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkCopyImageToMemoryInfo.nsrcImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyImageToMemoryInfo.nregionCount(this.address());
        }

        @NativeType(value="VkImageToMemoryCopy const *")
        public VkImageToMemoryCopy.Buffer pRegions() {
            return VkCopyImageToMemoryInfo.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkHostImageCopyFlags") int value) {
            VkCopyImageToMemoryInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToMemoryInfo.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToMemoryInfo.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageToMemoryCopy const *") VkImageToMemoryCopy.Buffer value) {
            VkCopyImageToMemoryInfo.npRegions(this.address(), value);
            return this;
        }
    }
}

