/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDecompressMemoryRegionNV
extends Struct<VkDecompressMemoryRegionNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCADDRESS;
    public static final int DSTADDRESS;
    public static final int COMPRESSEDSIZE;
    public static final int DECOMPRESSEDSIZE;
    public static final int DECOMPRESSIONMETHOD;

    protected VkDecompressMemoryRegionNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDecompressMemoryRegionNV create(long address, @Nullable ByteBuffer container) {
        return new VkDecompressMemoryRegionNV(address, container);
    }

    public VkDecompressMemoryRegionNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDecompressMemoryRegionNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long srcAddress() {
        return VkDecompressMemoryRegionNV.nsrcAddress(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long dstAddress() {
        return VkDecompressMemoryRegionNV.ndstAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long compressedSize() {
        return VkDecompressMemoryRegionNV.ncompressedSize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long decompressedSize() {
        return VkDecompressMemoryRegionNV.ndecompressedSize(this.address());
    }

    @NativeType(value="VkMemoryDecompressionMethodFlagsNV")
    public long decompressionMethod() {
        return VkDecompressMemoryRegionNV.ndecompressionMethod(this.address());
    }

    public VkDecompressMemoryRegionNV srcAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDecompressMemoryRegionNV.nsrcAddress(this.address(), value);
        return this;
    }

    public VkDecompressMemoryRegionNV dstAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDecompressMemoryRegionNV.ndstAddress(this.address(), value);
        return this;
    }

    public VkDecompressMemoryRegionNV compressedSize(@NativeType(value="VkDeviceSize") long value) {
        VkDecompressMemoryRegionNV.ncompressedSize(this.address(), value);
        return this;
    }

    public VkDecompressMemoryRegionNV decompressedSize(@NativeType(value="VkDeviceSize") long value) {
        VkDecompressMemoryRegionNV.ndecompressedSize(this.address(), value);
        return this;
    }

    public VkDecompressMemoryRegionNV decompressionMethod(@NativeType(value="VkMemoryDecompressionMethodFlagsNV") long value) {
        VkDecompressMemoryRegionNV.ndecompressionMethod(this.address(), value);
        return this;
    }

    public VkDecompressMemoryRegionNV set(long srcAddress, long dstAddress, long compressedSize, long decompressedSize, long decompressionMethod) {
        this.srcAddress(srcAddress);
        this.dstAddress(dstAddress);
        this.compressedSize(compressedSize);
        this.decompressedSize(decompressedSize);
        this.decompressionMethod(decompressionMethod);
        return this;
    }

    public VkDecompressMemoryRegionNV set(VkDecompressMemoryRegionNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDecompressMemoryRegionNV malloc() {
        return new VkDecompressMemoryRegionNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDecompressMemoryRegionNV calloc() {
        return new VkDecompressMemoryRegionNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDecompressMemoryRegionNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDecompressMemoryRegionNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDecompressMemoryRegionNV create(long address) {
        return new VkDecompressMemoryRegionNV(address, null);
    }

    public static @Nullable VkDecompressMemoryRegionNV createSafe(long address) {
        return address == 0L ? null : new VkDecompressMemoryRegionNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDecompressMemoryRegionNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDecompressMemoryRegionNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDecompressMemoryRegionNV malloc(MemoryStack stack) {
        return new VkDecompressMemoryRegionNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDecompressMemoryRegionNV calloc(MemoryStack stack) {
        return new VkDecompressMemoryRegionNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcAddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCADDRESS));
    }

    public static long ndstAddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTADDRESS));
    }

    public static long ncompressedSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)COMPRESSEDSIZE));
    }

    public static long ndecompressedSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DECOMPRESSEDSIZE));
    }

    public static long ndecompressionMethod(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DECOMPRESSIONMETHOD));
    }

    public static void nsrcAddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCADDRESS), (long)value);
    }

    public static void ndstAddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTADDRESS), (long)value);
    }

    public static void ncompressedSize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)COMPRESSEDSIZE), (long)value);
    }

    public static void ndecompressedSize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DECOMPRESSEDSIZE), (long)value);
    }

    public static void ndecompressionMethod(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DECOMPRESSIONMETHOD), (long)value);
    }

    static {
        Struct.Layout layout = VkDecompressMemoryRegionNV.__struct((Struct.Member[])new Struct.Member[]{VkDecompressMemoryRegionNV.__member((int)8), VkDecompressMemoryRegionNV.__member((int)8), VkDecompressMemoryRegionNV.__member((int)8), VkDecompressMemoryRegionNV.__member((int)8), VkDecompressMemoryRegionNV.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCADDRESS = layout.offsetof(0);
        DSTADDRESS = layout.offsetof(1);
        COMPRESSEDSIZE = layout.offsetof(2);
        DECOMPRESSEDSIZE = layout.offsetof(3);
        DECOMPRESSIONMETHOD = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDecompressMemoryRegionNV, Buffer>
    implements NativeResource {
        private static final VkDecompressMemoryRegionNV ELEMENT_FACTORY = VkDecompressMemoryRegionNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDecompressMemoryRegionNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long srcAddress() {
            return VkDecompressMemoryRegionNV.nsrcAddress(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long dstAddress() {
            return VkDecompressMemoryRegionNV.ndstAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long compressedSize() {
            return VkDecompressMemoryRegionNV.ncompressedSize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long decompressedSize() {
            return VkDecompressMemoryRegionNV.ndecompressedSize(this.address());
        }

        @NativeType(value="VkMemoryDecompressionMethodFlagsNV")
        public long decompressionMethod() {
            return VkDecompressMemoryRegionNV.ndecompressionMethod(this.address());
        }

        public Buffer srcAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDecompressMemoryRegionNV.nsrcAddress(this.address(), value);
            return this;
        }

        public Buffer dstAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDecompressMemoryRegionNV.ndstAddress(this.address(), value);
            return this;
        }

        public Buffer compressedSize(@NativeType(value="VkDeviceSize") long value) {
            VkDecompressMemoryRegionNV.ncompressedSize(this.address(), value);
            return this;
        }

        public Buffer decompressedSize(@NativeType(value="VkDeviceSize") long value) {
            VkDecompressMemoryRegionNV.ndecompressedSize(this.address(), value);
            return this;
        }

        public Buffer decompressionMethod(@NativeType(value="VkMemoryDecompressionMethodFlagsNV") long value) {
            VkDecompressMemoryRegionNV.ndecompressionMethod(this.address(), value);
            return this;
        }
    }
}

