/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorImageInfo
extends Struct<VkDescriptorImageInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLER;
    public static final int IMAGEVIEW;
    public static final int IMAGELAYOUT;

    protected VkDescriptorImageInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorImageInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorImageInfo(address, container);
    }

    public VkDescriptorImageInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorImageInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkSampler")
    public long sampler() {
        return VkDescriptorImageInfo.nsampler(this.address());
    }

    @NativeType(value="VkImageView")
    public long imageView() {
        return VkDescriptorImageInfo.nimageView(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int imageLayout() {
        return VkDescriptorImageInfo.nimageLayout(this.address());
    }

    public VkDescriptorImageInfo sampler(@NativeType(value="VkSampler") long value) {
        VkDescriptorImageInfo.nsampler(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo imageView(@NativeType(value="VkImageView") long value) {
        VkDescriptorImageInfo.nimageView(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo imageLayout(@NativeType(value="VkImageLayout") int value) {
        VkDescriptorImageInfo.nimageLayout(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo set(long sampler, long imageView, int imageLayout) {
        this.sampler(sampler);
        this.imageView(imageView);
        this.imageLayout(imageLayout);
        return this;
    }

    public VkDescriptorImageInfo set(VkDescriptorImageInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorImageInfo malloc() {
        return new VkDescriptorImageInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorImageInfo calloc() {
        return new VkDescriptorImageInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorImageInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorImageInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorImageInfo create(long address) {
        return new VkDescriptorImageInfo(address, null);
    }

    public static @Nullable VkDescriptorImageInfo createSafe(long address) {
        return address == 0L ? null : new VkDescriptorImageInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorImageInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorImageInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorImageInfo mallocStack() {
        return VkDescriptorImageInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorImageInfo callocStack() {
        return VkDescriptorImageInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorImageInfo mallocStack(MemoryStack stack) {
        return VkDescriptorImageInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorImageInfo callocStack(MemoryStack stack) {
        return VkDescriptorImageInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorImageInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorImageInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorImageInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorImageInfo.calloc(capacity, stack);
    }

    public static VkDescriptorImageInfo malloc(MemoryStack stack) {
        return new VkDescriptorImageInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorImageInfo calloc(MemoryStack stack) {
        return new VkDescriptorImageInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsampler(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SAMPLER));
    }

    public static long nimageView(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)IMAGEVIEW));
    }

    public static int nimageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGELAYOUT));
    }

    public static void nsampler(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SAMPLER), (long)value);
    }

    public static void nimageView(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)IMAGEVIEW), (long)value);
    }

    public static void nimageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGELAYOUT), (int)value);
    }

    static {
        Struct.Layout layout = VkDescriptorImageInfo.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorImageInfo.__member((int)8), VkDescriptorImageInfo.__member((int)8), VkDescriptorImageInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLER = layout.offsetof(0);
        IMAGEVIEW = layout.offsetof(1);
        IMAGELAYOUT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorImageInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorImageInfo ELEMENT_FACTORY = VkDescriptorImageInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDescriptorImageInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkSampler")
        public long sampler() {
            return VkDescriptorImageInfo.nsampler(this.address());
        }

        @NativeType(value="VkImageView")
        public long imageView() {
            return VkDescriptorImageInfo.nimageView(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int imageLayout() {
            return VkDescriptorImageInfo.nimageLayout(this.address());
        }

        public Buffer sampler(@NativeType(value="VkSampler") long value) {
            VkDescriptorImageInfo.nsampler(this.address(), value);
            return this;
        }

        public Buffer imageView(@NativeType(value="VkImageView") long value) {
            VkDescriptorImageInfo.nimageView(this.address(), value);
            return this;
        }

        public Buffer imageLayout(@NativeType(value="VkImageLayout") int value) {
            VkDescriptorImageInfo.nimageLayout(this.address(), value);
            return this;
        }
    }
}

