/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorUpdateTemplateEntry
extends Struct<VkDescriptorUpdateTemplateEntry>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;
    public static final int DESCRIPTORTYPE;
    public static final int OFFSET;
    public static final int STRIDE;

    protected VkDescriptorUpdateTemplateEntry(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorUpdateTemplateEntry create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorUpdateTemplateEntry(address, container);
    }

    public VkDescriptorUpdateTemplateEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorUpdateTemplateEntry.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int dstBinding() {
        return VkDescriptorUpdateTemplateEntry.ndstBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstArrayElement() {
        return VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address());
    }

    @NativeType(value="size_t")
    public long offset() {
        return VkDescriptorUpdateTemplateEntry.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long stride() {
        return VkDescriptorUpdateTemplateEntry.nstride(this.address());
    }

    public VkDescriptorUpdateTemplateEntry dstBinding(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateEntry.ndstBinding(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry dstArrayElement(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry descriptorCount(@NativeType(value="uint32_t") int value) {
        VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry offset(@NativeType(value="size_t") long value) {
        VkDescriptorUpdateTemplateEntry.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry stride(@NativeType(value="size_t") long value) {
        VkDescriptorUpdateTemplateEntry.nstride(this.address(), value);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry set(int dstBinding, int dstArrayElement, int descriptorCount, int descriptorType, long offset, long stride) {
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        this.descriptorType(descriptorType);
        this.offset(offset);
        this.stride(stride);
        return this;
    }

    public VkDescriptorUpdateTemplateEntry set(VkDescriptorUpdateTemplateEntry src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorUpdateTemplateEntry malloc() {
        return new VkDescriptorUpdateTemplateEntry(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorUpdateTemplateEntry calloc() {
        return new VkDescriptorUpdateTemplateEntry(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorUpdateTemplateEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorUpdateTemplateEntry(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorUpdateTemplateEntry create(long address) {
        return new VkDescriptorUpdateTemplateEntry(address, null);
    }

    public static @Nullable VkDescriptorUpdateTemplateEntry createSafe(long address) {
        return address == 0L ? null : new VkDescriptorUpdateTemplateEntry(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorUpdateTemplateEntry.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorUpdateTemplateEntry.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry mallocStack() {
        return VkDescriptorUpdateTemplateEntry.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry callocStack() {
        return VkDescriptorUpdateTemplateEntry.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry mallocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorUpdateTemplateEntry callocStack(MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorUpdateTemplateEntry.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorUpdateTemplateEntry.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorUpdateTemplateEntry.calloc(capacity, stack);
    }

    public static VkDescriptorUpdateTemplateEntry malloc(MemoryStack stack) {
        return new VkDescriptorUpdateTemplateEntry(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorUpdateTemplateEntry calloc(MemoryStack stack) {
        return new VkDescriptorUpdateTemplateEntry(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndstBinding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTBINDING));
    }

    public static int ndstArrayElement(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTARRAYELEMENT));
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DESCRIPTORCOUNT));
    }

    public static int ndescriptorType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DESCRIPTORTYPE));
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OFFSET));
    }

    public static long nstride(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)STRIDE));
    }

    public static void ndstBinding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTBINDING), (int)value);
    }

    public static void ndstArrayElement(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTARRAYELEMENT), (int)value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DESCRIPTORCOUNT), (int)value);
    }

    public static void ndescriptorType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DESCRIPTORTYPE), (int)value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nstride(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)STRIDE), (long)value);
    }

    static {
        Struct.Layout layout = VkDescriptorUpdateTemplateEntry.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorUpdateTemplateEntry.__member((int)4), VkDescriptorUpdateTemplateEntry.__member((int)4), VkDescriptorUpdateTemplateEntry.__member((int)4), VkDescriptorUpdateTemplateEntry.__member((int)4), VkDescriptorUpdateTemplateEntry.__member((int)POINTER_SIZE), VkDescriptorUpdateTemplateEntry.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DSTBINDING = layout.offsetof(0);
        DSTARRAYELEMENT = layout.offsetof(1);
        DESCRIPTORCOUNT = layout.offsetof(2);
        DESCRIPTORTYPE = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        STRIDE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorUpdateTemplateEntry, Buffer>
    implements NativeResource {
        private static final VkDescriptorUpdateTemplateEntry ELEMENT_FACTORY = VkDescriptorUpdateTemplateEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDescriptorUpdateTemplateEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int dstBinding() {
            return VkDescriptorUpdateTemplateEntry.ndstBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstArrayElement() {
            return VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address());
        }

        @NativeType(value="size_t")
        public long offset() {
            return VkDescriptorUpdateTemplateEntry.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long stride() {
            return VkDescriptorUpdateTemplateEntry.nstride(this.address());
        }

        public Buffer dstBinding(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateEntry.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateEntry.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkDescriptorUpdateTemplateEntry.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorUpdateTemplateEntry.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="size_t") long value) {
            VkDescriptorUpdateTemplateEntry.noffset(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="size_t") long value) {
            VkDescriptorUpdateTemplateEntry.nstride(this.address(), value);
            return this;
        }
    }
}

