/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceQueueInfo2
extends Struct<VkDeviceQueueInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUEUEFAMILYINDEX;
    public static final int QUEUEINDEX;

    protected VkDeviceQueueInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceQueueInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceQueueInfo2(address, container);
    }

    public VkDeviceQueueInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceQueueInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceQueueInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceQueueInfo2.npNext(this.address());
    }

    @NativeType(value="VkDeviceQueueCreateFlags")
    public int flags() {
        return VkDeviceQueueInfo2.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkDeviceQueueInfo2.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueIndex() {
        return VkDeviceQueueInfo2.nqueueIndex(this.address());
    }

    public VkDeviceQueueInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceQueueInfo2.nsType(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 sType$Default() {
        return this.sType(1000145003);
    }

    public VkDeviceQueueInfo2 pNext(@NativeType(value="void const *") long value) {
        VkDeviceQueueInfo2.npNext(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
        VkDeviceQueueInfo2.nflags(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceQueueInfo2.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 queueIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceQueueInfo2.nqueueIndex(this.address(), value);
        return this;
    }

    public VkDeviceQueueInfo2 set(int sType, long pNext, int flags, int queueFamilyIndex, int queueIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queueFamilyIndex(queueFamilyIndex);
        this.queueIndex(queueIndex);
        return this;
    }

    public VkDeviceQueueInfo2 set(VkDeviceQueueInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceQueueInfo2 malloc() {
        return new VkDeviceQueueInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceQueueInfo2 calloc() {
        return new VkDeviceQueueInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceQueueInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceQueueInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceQueueInfo2 create(long address) {
        return new VkDeviceQueueInfo2(address, null);
    }

    public static @Nullable VkDeviceQueueInfo2 createSafe(long address) {
        return address == 0L ? null : new VkDeviceQueueInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceQueueInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceQueueInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceQueueInfo2 mallocStack() {
        return VkDeviceQueueInfo2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceQueueInfo2 callocStack() {
        return VkDeviceQueueInfo2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceQueueInfo2 mallocStack(MemoryStack stack) {
        return VkDeviceQueueInfo2.malloc(stack);
    }

    @Deprecated
    public static VkDeviceQueueInfo2 callocStack(MemoryStack stack) {
        return VkDeviceQueueInfo2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceQueueInfo2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceQueueInfo2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueInfo2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceQueueInfo2.calloc(capacity, stack);
    }

    public static VkDeviceQueueInfo2 malloc(MemoryStack stack) {
        return new VkDeviceQueueInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceQueueInfo2 calloc(MemoryStack stack) {
        return new VkDeviceQueueInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nqueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUEFAMILYINDEX));
    }

    public static int nqueueIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUEINDEX));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)QUEUEFAMILYINDEX), (int)value);
    }

    public static void nqueueIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)QUEUEINDEX), (int)value);
    }

    static {
        Struct.Layout layout = VkDeviceQueueInfo2.__struct((Struct.Member[])new Struct.Member[]{VkDeviceQueueInfo2.__member((int)4), VkDeviceQueueInfo2.__member((int)POINTER_SIZE), VkDeviceQueueInfo2.__member((int)4), VkDeviceQueueInfo2.__member((int)4), VkDeviceQueueInfo2.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUEUEFAMILYINDEX = layout.offsetof(3);
        QUEUEINDEX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceQueueInfo2, Buffer>
    implements NativeResource {
        private static final VkDeviceQueueInfo2 ELEMENT_FACTORY = VkDeviceQueueInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDeviceQueueInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceQueueInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceQueueInfo2.npNext(this.address());
        }

        @NativeType(value="VkDeviceQueueCreateFlags")
        public int flags() {
            return VkDeviceQueueInfo2.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkDeviceQueueInfo2.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueIndex() {
            return VkDeviceQueueInfo2.nqueueIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceQueueInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000145003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceQueueInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDeviceQueueCreateFlags") int value) {
            VkDeviceQueueInfo2.nflags(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceQueueInfo2.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer queueIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceQueueInfo2.nqueueIndex(this.address(), value);
            return this;
        }
    }
}

