/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDrawIndexedIndirectCommand
extends Struct<VkDrawIndexedIndirectCommand>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEXCOUNT;
    public static final int INSTANCECOUNT;
    public static final int FIRSTINDEX;
    public static final int VERTEXOFFSET;
    public static final int FIRSTINSTANCE;

    protected VkDrawIndexedIndirectCommand(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDrawIndexedIndirectCommand create(long address, @Nullable ByteBuffer container) {
        return new VkDrawIndexedIndirectCommand(address, container);
    }

    public VkDrawIndexedIndirectCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDrawIndexedIndirectCommand.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int indexCount() {
        return VkDrawIndexedIndirectCommand.nindexCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCount() {
        return VkDrawIndexedIndirectCommand.ninstanceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstIndex() {
        return VkDrawIndexedIndirectCommand.nfirstIndex(this.address());
    }

    @NativeType(value="int32_t")
    public int vertexOffset() {
        return VkDrawIndexedIndirectCommand.nvertexOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstInstance() {
        return VkDrawIndexedIndirectCommand.nfirstInstance(this.address());
    }

    public VkDrawIndexedIndirectCommand indexCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.nindexCount(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand instanceCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.ninstanceCount(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand firstIndex(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.nfirstIndex(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand vertexOffset(@NativeType(value="int32_t") int value) {
        VkDrawIndexedIndirectCommand.nvertexOffset(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand firstInstance(@NativeType(value="uint32_t") int value) {
        VkDrawIndexedIndirectCommand.nfirstInstance(this.address(), value);
        return this;
    }

    public VkDrawIndexedIndirectCommand set(int indexCount, int instanceCount, int firstIndex, int vertexOffset, int firstInstance) {
        this.indexCount(indexCount);
        this.instanceCount(instanceCount);
        this.firstIndex(firstIndex);
        this.vertexOffset(vertexOffset);
        this.firstInstance(firstInstance);
        return this;
    }

    public VkDrawIndexedIndirectCommand set(VkDrawIndexedIndirectCommand src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDrawIndexedIndirectCommand malloc() {
        return new VkDrawIndexedIndirectCommand(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDrawIndexedIndirectCommand calloc() {
        return new VkDrawIndexedIndirectCommand(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDrawIndexedIndirectCommand create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDrawIndexedIndirectCommand(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDrawIndexedIndirectCommand create(long address) {
        return new VkDrawIndexedIndirectCommand(address, null);
    }

    public static @Nullable VkDrawIndexedIndirectCommand createSafe(long address) {
        return address == 0L ? null : new VkDrawIndexedIndirectCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDrawIndexedIndirectCommand.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDrawIndexedIndirectCommand.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDrawIndexedIndirectCommand mallocStack() {
        return VkDrawIndexedIndirectCommand.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDrawIndexedIndirectCommand callocStack() {
        return VkDrawIndexedIndirectCommand.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDrawIndexedIndirectCommand mallocStack(MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.malloc(stack);
    }

    @Deprecated
    public static VkDrawIndexedIndirectCommand callocStack(MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDrawIndexedIndirectCommand.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDrawIndexedIndirectCommand.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDrawIndexedIndirectCommand.calloc(capacity, stack);
    }

    public static VkDrawIndexedIndirectCommand malloc(MemoryStack stack) {
        return new VkDrawIndexedIndirectCommand(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDrawIndexedIndirectCommand calloc(MemoryStack stack) {
        return new VkDrawIndexedIndirectCommand(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nindexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INDEXCOUNT));
    }

    public static int ninstanceCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INSTANCECOUNT));
    }

    public static int nfirstIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FIRSTINDEX));
    }

    public static int nvertexOffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VERTEXOFFSET));
    }

    public static int nfirstInstance(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FIRSTINSTANCE));
    }

    public static void nindexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INDEXCOUNT), (int)value);
    }

    public static void ninstanceCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INSTANCECOUNT), (int)value);
    }

    public static void nfirstIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FIRSTINDEX), (int)value);
    }

    public static void nvertexOffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VERTEXOFFSET), (int)value);
    }

    public static void nfirstInstance(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FIRSTINSTANCE), (int)value);
    }

    static {
        Struct.Layout layout = VkDrawIndexedIndirectCommand.__struct((Struct.Member[])new Struct.Member[]{VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4), VkDrawIndexedIndirectCommand.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEXCOUNT = layout.offsetof(0);
        INSTANCECOUNT = layout.offsetof(1);
        FIRSTINDEX = layout.offsetof(2);
        VERTEXOFFSET = layout.offsetof(3);
        FIRSTINSTANCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDrawIndexedIndirectCommand, Buffer>
    implements NativeResource {
        private static final VkDrawIndexedIndirectCommand ELEMENT_FACTORY = VkDrawIndexedIndirectCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDrawIndexedIndirectCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int indexCount() {
            return VkDrawIndexedIndirectCommand.nindexCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCount() {
            return VkDrawIndexedIndirectCommand.ninstanceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstIndex() {
            return VkDrawIndexedIndirectCommand.nfirstIndex(this.address());
        }

        @NativeType(value="int32_t")
        public int vertexOffset() {
            return VkDrawIndexedIndirectCommand.nvertexOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstInstance() {
            return VkDrawIndexedIndirectCommand.nfirstInstance(this.address());
        }

        public Buffer indexCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.nindexCount(this.address(), value);
            return this;
        }

        public Buffer instanceCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer firstIndex(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.nfirstIndex(this.address(), value);
            return this;
        }

        public Buffer vertexOffset(@NativeType(value="int32_t") int value) {
            VkDrawIndexedIndirectCommand.nvertexOffset(this.address(), value);
            return this;
        }

        public Buffer firstInstance(@NativeType(value="uint32_t") int value) {
            VkDrawIndexedIndirectCommand.nfirstInstance(this.address(), value);
            return this;
        }
    }
}

