/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryBufferCreateInfo
extends Struct<VkExternalMemoryBufferCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    protected VkExternalMemoryBufferCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkExternalMemoryBufferCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkExternalMemoryBufferCreateInfo(address, container);
    }

    public VkExternalMemoryBufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExternalMemoryBufferCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryBufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryBufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
    }

    public VkExternalMemoryBufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo sType$Default() {
        return this.sType(1000072000);
    }

    public VkExternalMemoryBufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(VkExternalMemoryBufferCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfo malloc() {
        return new VkExternalMemoryBufferCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkExternalMemoryBufferCreateInfo calloc() {
        return new VkExternalMemoryBufferCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkExternalMemoryBufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkExternalMemoryBufferCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkExternalMemoryBufferCreateInfo create(long address) {
        return new VkExternalMemoryBufferCreateInfo(address, null);
    }

    public static @Nullable VkExternalMemoryBufferCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkExternalMemoryBufferCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkExternalMemoryBufferCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryBufferCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo mallocStack() {
        return VkExternalMemoryBufferCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo callocStack() {
        return VkExternalMemoryBufferCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.calloc(capacity, stack);
    }

    public static VkExternalMemoryBufferCreateInfo malloc(MemoryStack stack) {
        return new VkExternalMemoryBufferCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExternalMemoryBufferCreateInfo calloc(MemoryStack stack) {
        return new VkExternalMemoryBufferCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HANDLETYPES));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HANDLETYPES), (int)value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryBufferCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkExternalMemoryBufferCreateInfo.__member((int)4), VkExternalMemoryBufferCreateInfo.__member((int)POINTER_SIZE), VkExternalMemoryBufferCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryBufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkExternalMemoryBufferCreateInfo ELEMENT_FACTORY = VkExternalMemoryBufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkExternalMemoryBufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryBufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryBufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000072000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

