/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkLayerProperties
extends Struct<VkLayerProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAYERNAME;
    public static final int SPECVERSION;
    public static final int IMPLEMENTATIONVERSION;
    public static final int DESCRIPTION;

    protected VkLayerProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkLayerProperties create(long address, @Nullable ByteBuffer container) {
        return new VkLayerProperties(address, container);
    }

    public VkLayerProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkLayerProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer layerName() {
        return VkLayerProperties.nlayerName(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String layerNameString() {
        return VkLayerProperties.nlayerNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int specVersion() {
        return VkLayerProperties.nspecVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int implementationVersion() {
        return VkLayerProperties.nimplementationVersion(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public ByteBuffer description() {
        return VkLayerProperties.ndescription(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public String descriptionString() {
        return VkLayerProperties.ndescriptionString(this.address());
    }

    public static VkLayerProperties malloc() {
        return new VkLayerProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkLayerProperties calloc() {
        return new VkLayerProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkLayerProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkLayerProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkLayerProperties create(long address) {
        return new VkLayerProperties(address, null);
    }

    public static @Nullable VkLayerProperties createSafe(long address) {
        return address == 0L ? null : new VkLayerProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkLayerProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkLayerProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkLayerProperties mallocStack() {
        return VkLayerProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkLayerProperties callocStack() {
        return VkLayerProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkLayerProperties mallocStack(MemoryStack stack) {
        return VkLayerProperties.malloc(stack);
    }

    @Deprecated
    public static VkLayerProperties callocStack(MemoryStack stack) {
        return VkLayerProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkLayerProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkLayerProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkLayerProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkLayerProperties.calloc(capacity, stack);
    }

    public static VkLayerProperties malloc(MemoryStack stack) {
        return new VkLayerProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkLayerProperties calloc(MemoryStack stack) {
        return new VkLayerProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nlayerName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LAYERNAME), (int)256);
    }

    public static String nlayerNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)LAYERNAME));
    }

    public static int nspecVersion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SPECVERSION));
    }

    public static int nimplementationVersion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMPLEMENTATIONVERSION));
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DESCRIPTION), (int)256);
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DESCRIPTION));
    }

    static {
        Struct.Layout layout = VkLayerProperties.__struct((Struct.Member[])new Struct.Member[]{VkLayerProperties.__array((int)1, (int)256), VkLayerProperties.__member((int)4), VkLayerProperties.__member((int)4), VkLayerProperties.__array((int)1, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LAYERNAME = layout.offsetof(0);
        SPECVERSION = layout.offsetof(1);
        IMPLEMENTATIONVERSION = layout.offsetof(2);
        DESCRIPTION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkLayerProperties, Buffer>
    implements NativeResource {
        private static final VkLayerProperties ELEMENT_FACTORY = VkLayerProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkLayerProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer layerName() {
            return VkLayerProperties.nlayerName(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String layerNameString() {
            return VkLayerProperties.nlayerNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int specVersion() {
            return VkLayerProperties.nspecVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int implementationVersion() {
            return VkLayerProperties.nimplementationVersion(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public ByteBuffer description() {
            return VkLayerProperties.ndescription(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public String descriptionString() {
            return VkLayerProperties.ndescriptionString(this.address());
        }
    }
}

