/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryDedicatedAllocateInfo
extends Struct<VkMemoryDedicatedAllocateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int BUFFER;

    protected VkMemoryDedicatedAllocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryDedicatedAllocateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryDedicatedAllocateInfo(address, container);
    }

    public VkMemoryDedicatedAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryDedicatedAllocateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryDedicatedAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryDedicatedAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkMemoryDedicatedAllocateInfo.nimage(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkMemoryDedicatedAllocateInfo.nbuffer(this.address());
    }

    public VkMemoryDedicatedAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo sType$Default() {
        return this.sType(1000127001);
    }

    public VkMemoryDedicatedAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryDedicatedAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo image(@NativeType(value="VkImage") long value) {
        VkMemoryDedicatedAllocateInfo.nimage(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkMemoryDedicatedAllocateInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo set(int sType, long pNext, long image, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.buffer(buffer);
        return this;
    }

    public VkMemoryDedicatedAllocateInfo set(VkMemoryDedicatedAllocateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedAllocateInfo malloc() {
        return new VkMemoryDedicatedAllocateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryDedicatedAllocateInfo calloc() {
        return new VkMemoryDedicatedAllocateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryDedicatedAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryDedicatedAllocateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryDedicatedAllocateInfo create(long address) {
        return new VkMemoryDedicatedAllocateInfo(address, null);
    }

    public static @Nullable VkMemoryDedicatedAllocateInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryDedicatedAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryDedicatedAllocateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryDedicatedAllocateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfo mallocStack() {
        return VkMemoryDedicatedAllocateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfo callocStack() {
        return VkMemoryDedicatedAllocateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfo mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.malloc(stack);
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfo callocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfo.calloc(capacity, stack);
    }

    public static VkMemoryDedicatedAllocateInfo malloc(MemoryStack stack) {
        return new VkMemoryDedicatedAllocateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryDedicatedAllocateInfo calloc(MemoryStack stack) {
        return new VkMemoryDedicatedAllocateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)IMAGE));
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUFFER));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)IMAGE), (long)value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BUFFER), (long)value);
    }

    static {
        Struct.Layout layout = VkMemoryDedicatedAllocateInfo.__struct((Struct.Member[])new Struct.Member[]{VkMemoryDedicatedAllocateInfo.__member((int)4), VkMemoryDedicatedAllocateInfo.__member((int)POINTER_SIZE), VkMemoryDedicatedAllocateInfo.__member((int)8), VkMemoryDedicatedAllocateInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryDedicatedAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryDedicatedAllocateInfo ELEMENT_FACTORY = VkMemoryDedicatedAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMemoryDedicatedAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryDedicatedAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryDedicatedAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkMemoryDedicatedAllocateInfo.nimage(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkMemoryDedicatedAllocateInfo.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000127001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryDedicatedAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkMemoryDedicatedAllocateInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkMemoryDedicatedAllocateInfo.nbuffer(this.address(), value);
            return this;
        }
    }
}

