/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryMapPlacedInfoEXT;

public class VkMemoryMapInfo
extends Struct<VkMemoryMapInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MEMORY;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkMemoryMapInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryMapInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryMapInfo(address, container);
    }

    public VkMemoryMapInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryMapInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryMapInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryMapInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryMapFlags")
    public int flags() {
        return VkMemoryMapInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryMapInfo.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkMemoryMapInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryMapInfo.nsize(this.address());
    }

    public VkMemoryMapInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryMapInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo sType$Default() {
        return this.sType(1000271000);
    }

    public VkMemoryMapInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryMapInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo pNext(VkMemoryMapPlacedInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryMapInfo flags(@NativeType(value="VkMemoryMapFlags") int value) {
        VkMemoryMapInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryMapInfo.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo offset(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfo.noffset(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo size(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfo.nsize(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo set(int sType, long pNext, int flags, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMemoryMapInfo set(VkMemoryMapInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryMapInfo malloc() {
        return new VkMemoryMapInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryMapInfo calloc() {
        return new VkMemoryMapInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryMapInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryMapInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryMapInfo create(long address) {
        return new VkMemoryMapInfo(address, null);
    }

    public static @Nullable VkMemoryMapInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryMapInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryMapInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryMapInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryMapInfo malloc(MemoryStack stack) {
        return new VkMemoryMapInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryMapInfo calloc(MemoryStack stack) {
        return new VkMemoryMapInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MEMORY));
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MEMORY), (long)value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkMemoryMapInfo.__struct((Struct.Member[])new Struct.Member[]{VkMemoryMapInfo.__member((int)4), VkMemoryMapInfo.__member((int)POINTER_SIZE), VkMemoryMapInfo.__member((int)4), VkMemoryMapInfo.__member((int)8), VkMemoryMapInfo.__member((int)8), VkMemoryMapInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryMapInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryMapInfo ELEMENT_FACTORY = VkMemoryMapInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMemoryMapInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryMapInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryMapInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryMapFlags")
        public int flags() {
            return VkMemoryMapInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryMapInfo.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkMemoryMapInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryMapInfo.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryMapInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000271000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryMapInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkMemoryMapPlacedInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkMemoryMapFlags") int value) {
            VkMemoryMapInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryMapInfo.nmemory(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfo.nsize(this.address(), value);
            return this;
        }
    }
}

