/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryMapInfo;

public class VkMemoryMapInfoKHR
extends VkMemoryMapInfo {
    protected VkMemoryMapInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryMapInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryMapInfoKHR(address, container);
    }

    public VkMemoryMapInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryMapInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryMapInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryMapInfoKHR sType$Default() {
        return this.sType(1000271000);
    }

    @Override
    public VkMemoryMapInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryMapInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryMapInfoKHR flags(@NativeType(value="VkMemoryMapFlags") int value) {
        VkMemoryMapInfoKHR.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryMapInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryMapInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryMapInfoKHR offset(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfoKHR.noffset(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryMapInfoKHR size(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfoKHR.nsize(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryMapInfoKHR set(int sType, long pNext, int flags, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMemoryMapInfoKHR set(VkMemoryMapInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryMapInfoKHR malloc() {
        return new VkMemoryMapInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryMapInfoKHR calloc() {
        return new VkMemoryMapInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryMapInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryMapInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryMapInfoKHR create(long address) {
        return new VkMemoryMapInfoKHR(address, null);
    }

    public static @Nullable VkMemoryMapInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryMapInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryMapInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryMapInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryMapInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryMapInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryMapInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryMapInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryMapInfo.Buffer {
        private static final VkMemoryMapInfoKHR ELEMENT_FACTORY = VkMemoryMapInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryMapInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryMapInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000271000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryMapInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkMemoryMapFlags") int value) {
            VkMemoryMapInfoKHR.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryMapInfoKHR.nmemory(this.address(), value);
            return this;
        }

        @Override
        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfoKHR.noffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfoKHR.nsize(this.address(), value);
            return this;
        }
    }
}

