/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryOpaqueCaptureAddressAllocateInfo;

public class VkMemoryOpaqueCaptureAddressAllocateInfoKHR
extends VkMemoryOpaqueCaptureAddressAllocateInfo {
    protected VkMemoryOpaqueCaptureAddressAllocateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryOpaqueCaptureAddressAllocateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(address, container);
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR sType$Default() {
        return this.sType(1000257003);
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nopaqueCaptureAddress(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR set(int sType, long pNext, long opaqueCaptureAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.opaqueCaptureAddress(opaqueCaptureAddress);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfoKHR set(VkMemoryOpaqueCaptureAddressAllocateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR malloc() {
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR calloc() {
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR create(long address) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(address, null);
    }

    public static @Nullable VkMemoryOpaqueCaptureAddressAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryOpaqueCaptureAddressAllocateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryOpaqueCaptureAddressAllocateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryOpaqueCaptureAddressAllocateInfo.Buffer {
        private static final VkMemoryOpaqueCaptureAddressAllocateInfoKHR ELEMENT_FACTORY = VkMemoryOpaqueCaptureAddressAllocateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryOpaqueCaptureAddressAllocateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000257003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfoKHR.nopaqueCaptureAddress(this.address(), value);
            return this;
        }
    }
}

