/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryType
extends Struct<VkMemoryType> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROPERTYFLAGS;
    public static final int HEAPINDEX;

    protected VkMemoryType(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryType create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryType(address, container);
    }

    public VkMemoryType(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryType.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkMemoryPropertyFlags")
    public int propertyFlags() {
        return VkMemoryType.npropertyFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int heapIndex() {
        return VkMemoryType.nheapIndex(this.address());
    }

    public static VkMemoryType create(long address) {
        return new VkMemoryType(address, null);
    }

    public static @Nullable VkMemoryType createSafe(long address) {
        return address == 0L ? null : new VkMemoryType(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int npropertyFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PROPERTYFLAGS));
    }

    public static int nheapIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEAPINDEX));
    }

    static {
        Struct.Layout layout = VkMemoryType.__struct((Struct.Member[])new Struct.Member[]{VkMemoryType.__member((int)4), VkMemoryType.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROPERTYFLAGS = layout.offsetof(0);
        HEAPINDEX = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryType, Buffer> {
        private static final VkMemoryType ELEMENT_FACTORY = VkMemoryType.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMemoryType getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkMemoryPropertyFlags")
        public int propertyFlags() {
            return VkMemoryType.npropertyFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int heapIndex() {
            return VkMemoryType.nheapIndex(this.address());
        }
    }
}

