/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPerformanceCounterKHR
extends Struct<VkPerformanceCounterKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int UNIT;
    public static final int SCOPE;
    public static final int STORAGE;
    public static final int UUID;

    protected VkPerformanceCounterKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPerformanceCounterKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPerformanceCounterKHR(address, container);
    }

    public VkPerformanceCounterKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPerformanceCounterKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPerformanceCounterKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPerformanceCounterKHR.npNext(this.address());
    }

    @NativeType(value="VkPerformanceCounterUnitKHR")
    public int unit() {
        return VkPerformanceCounterKHR.nunit(this.address());
    }

    @NativeType(value="VkPerformanceCounterScopeKHR")
    public int scope() {
        return VkPerformanceCounterKHR.nscope(this.address());
    }

    @NativeType(value="VkPerformanceCounterStorageKHR")
    public int storage() {
        return VkPerformanceCounterKHR.nstorage(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer uuid() {
        return VkPerformanceCounterKHR.nuuid(this.address());
    }

    @NativeType(value="uint8_t")
    public byte uuid(int index) {
        return VkPerformanceCounterKHR.nuuid(this.address(), index);
    }

    public VkPerformanceCounterKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPerformanceCounterKHR.nsType(this.address(), value);
        return this;
    }

    public VkPerformanceCounterKHR sType$Default() {
        return this.sType(1000116005);
    }

    public VkPerformanceCounterKHR pNext(@NativeType(value="void *") long value) {
        VkPerformanceCounterKHR.npNext(this.address(), value);
        return this;
    }

    public VkPerformanceCounterKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPerformanceCounterKHR set(VkPerformanceCounterKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPerformanceCounterKHR malloc() {
        return new VkPerformanceCounterKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPerformanceCounterKHR calloc() {
        return new VkPerformanceCounterKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPerformanceCounterKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPerformanceCounterKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPerformanceCounterKHR create(long address) {
        return new VkPerformanceCounterKHR(address, null);
    }

    public static @Nullable VkPerformanceCounterKHR createSafe(long address) {
        return address == 0L ? null : new VkPerformanceCounterKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPerformanceCounterKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPerformanceCounterKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPerformanceCounterKHR malloc(MemoryStack stack) {
        return new VkPerformanceCounterKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPerformanceCounterKHR calloc(MemoryStack stack) {
        return new VkPerformanceCounterKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nunit(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UNIT));
    }

    public static int nscope(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SCOPE));
    }

    public static int nstorage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STORAGE));
    }

    public static ByteBuffer nuuid(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)UUID), (int)16);
    }

    public static byte nuuid(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)UUID + Checks.check((int)index, (int)16) * 1L));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPerformanceCounterKHR.__struct((Struct.Member[])new Struct.Member[]{VkPerformanceCounterKHR.__member((int)4), VkPerformanceCounterKHR.__member((int)POINTER_SIZE), VkPerformanceCounterKHR.__member((int)4), VkPerformanceCounterKHR.__member((int)4), VkPerformanceCounterKHR.__member((int)4), VkPerformanceCounterKHR.__array((int)1, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        UNIT = layout.offsetof(2);
        SCOPE = layout.offsetof(3);
        STORAGE = layout.offsetof(4);
        UUID = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPerformanceCounterKHR, Buffer>
    implements NativeResource {
        private static final VkPerformanceCounterKHR ELEMENT_FACTORY = VkPerformanceCounterKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPerformanceCounterKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPerformanceCounterKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPerformanceCounterKHR.npNext(this.address());
        }

        @NativeType(value="VkPerformanceCounterUnitKHR")
        public int unit() {
            return VkPerformanceCounterKHR.nunit(this.address());
        }

        @NativeType(value="VkPerformanceCounterScopeKHR")
        public int scope() {
            return VkPerformanceCounterKHR.nscope(this.address());
        }

        @NativeType(value="VkPerformanceCounterStorageKHR")
        public int storage() {
            return VkPerformanceCounterKHR.nstorage(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer uuid() {
            return VkPerformanceCounterKHR.nuuid(this.address());
        }

        @NativeType(value="uint8_t")
        public byte uuid(int index) {
            return VkPerformanceCounterKHR.nuuid(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPerformanceCounterKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000116005);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPerformanceCounterKHR.npNext(this.address(), value);
            return this;
        }
    }
}

