/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceHostImageCopyProperties
extends Struct<VkPhysicalDeviceHostImageCopyProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COPYSRCLAYOUTCOUNT;
    public static final int PCOPYSRCLAYOUTS;
    public static final int COPYDSTLAYOUTCOUNT;
    public static final int PCOPYDSTLAYOUTS;
    public static final int OPTIMALTILINGLAYOUTUUID;
    public static final int IDENTICALMEMORYTYPEREQUIREMENTS;

    protected VkPhysicalDeviceHostImageCopyProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPhysicalDeviceHostImageCopyProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceHostImageCopyProperties(address, container);
    }

    public VkPhysicalDeviceHostImageCopyProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceHostImageCopyProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceHostImageCopyProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceHostImageCopyProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int copySrcLayoutCount() {
        return VkPhysicalDeviceHostImageCopyProperties.ncopySrcLayoutCount(this.address());
    }

    @NativeType(value="VkImageLayout *")
    public @Nullable IntBuffer pCopySrcLayouts() {
        return VkPhysicalDeviceHostImageCopyProperties.npCopySrcLayouts(this.address());
    }

    @NativeType(value="uint32_t")
    public int copyDstLayoutCount() {
        return VkPhysicalDeviceHostImageCopyProperties.ncopyDstLayoutCount(this.address());
    }

    @NativeType(value="VkImageLayout *")
    public @Nullable IntBuffer pCopyDstLayouts() {
        return VkPhysicalDeviceHostImageCopyProperties.npCopyDstLayouts(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer optimalTilingLayoutUUID() {
        return VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte optimalTilingLayoutUUID(int index) {
        return VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address(), index);
    }

    @NativeType(value="VkBool32")
    public boolean identicalMemoryTypeRequirements() {
        return VkPhysicalDeviceHostImageCopyProperties.nidenticalMemoryTypeRequirements(this.address()) != 0;
    }

    public VkPhysicalDeviceHostImageCopyProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceHostImageCopyProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties sType$Default() {
        return this.sType(1000270001);
    }

    public VkPhysicalDeviceHostImageCopyProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceHostImageCopyProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties copySrcLayoutCount(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceHostImageCopyProperties.ncopySrcLayoutCount(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties pCopySrcLayouts(@NativeType(value="VkImageLayout *") @Nullable IntBuffer value) {
        VkPhysicalDeviceHostImageCopyProperties.npCopySrcLayouts(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties copyDstLayoutCount(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceHostImageCopyProperties.ncopyDstLayoutCount(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties pCopyDstLayouts(@NativeType(value="VkImageLayout *") @Nullable IntBuffer value) {
        VkPhysicalDeviceHostImageCopyProperties.npCopyDstLayouts(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties optimalTilingLayoutUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties optimalTilingLayoutUUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address(), index, value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties identicalMemoryTypeRequirements(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceHostImageCopyProperties.nidenticalMemoryTypeRequirements(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties set(int sType, long pNext, int copySrcLayoutCount, @Nullable IntBuffer pCopySrcLayouts, int copyDstLayoutCount, @Nullable IntBuffer pCopyDstLayouts, ByteBuffer optimalTilingLayoutUUID, boolean identicalMemoryTypeRequirements) {
        this.sType(sType);
        this.pNext(pNext);
        this.copySrcLayoutCount(copySrcLayoutCount);
        this.pCopySrcLayouts(pCopySrcLayouts);
        this.copyDstLayoutCount(copyDstLayoutCount);
        this.pCopyDstLayouts(pCopyDstLayouts);
        this.optimalTilingLayoutUUID(optimalTilingLayoutUUID);
        this.identicalMemoryTypeRequirements(identicalMemoryTypeRequirements);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyProperties set(VkPhysicalDeviceHostImageCopyProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceHostImageCopyProperties malloc() {
        return new VkPhysicalDeviceHostImageCopyProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPhysicalDeviceHostImageCopyProperties calloc() {
        return new VkPhysicalDeviceHostImageCopyProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPhysicalDeviceHostImageCopyProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPhysicalDeviceHostImageCopyProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPhysicalDeviceHostImageCopyProperties create(long address) {
        return new VkPhysicalDeviceHostImageCopyProperties(address, null);
    }

    public static @Nullable VkPhysicalDeviceHostImageCopyProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceHostImageCopyProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceHostImageCopyProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceHostImageCopyProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPhysicalDeviceHostImageCopyProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceHostImageCopyProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceHostImageCopyProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceHostImageCopyProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ncopySrcLayoutCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COPYSRCLAYOUTCOUNT));
    }

    public static @Nullable IntBuffer npCopySrcLayouts(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOPYSRCLAYOUTS)), (int)VkPhysicalDeviceHostImageCopyProperties.ncopySrcLayoutCount(struct));
    }

    public static int ncopyDstLayoutCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COPYDSTLAYOUTCOUNT));
    }

    public static @Nullable IntBuffer npCopyDstLayouts(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOPYDSTLAYOUTS)), (int)VkPhysicalDeviceHostImageCopyProperties.ncopyDstLayoutCount(struct));
    }

    public static ByteBuffer noptimalTilingLayoutUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)OPTIMALTILINGLAYOUTUUID), (int)16);
    }

    public static byte noptimalTilingLayoutUUID(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)OPTIMALTILINGLAYOUTUUID + Checks.check((int)index, (int)16) * 1L));
    }

    public static int nidenticalMemoryTypeRequirements(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IDENTICALMEMORYTYPEREQUIREMENTS));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ncopySrcLayoutCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COPYSRCLAYOUTCOUNT), (int)value);
    }

    public static void npCopySrcLayouts(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOPYSRCLAYOUTS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        if (value != null) {
            VkPhysicalDeviceHostImageCopyProperties.ncopySrcLayoutCount(struct, value.remaining());
        }
    }

    public static void ncopyDstLayoutCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COPYDSTLAYOUTCOUNT), (int)value);
    }

    public static void npCopyDstLayouts(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOPYDSTLAYOUTS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        if (value != null) {
            VkPhysicalDeviceHostImageCopyProperties.ncopyDstLayoutCount(struct, value.remaining());
        }
    }

    public static void noptimalTilingLayoutUUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)OPTIMALTILINGLAYOUTUUID), (long)(value.remaining() * 1));
    }

    public static void noptimalTilingLayoutUUID(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)OPTIMALTILINGLAYOUTUUID + Checks.check((int)index, (int)16) * 1L), (byte)value);
    }

    public static void nidenticalMemoryTypeRequirements(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IDENTICALMEMORYTYPEREQUIREMENTS), (int)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceHostImageCopyProperties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceHostImageCopyProperties.__member((int)4), VkPhysicalDeviceHostImageCopyProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceHostImageCopyProperties.__member((int)4), VkPhysicalDeviceHostImageCopyProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceHostImageCopyProperties.__member((int)4), VkPhysicalDeviceHostImageCopyProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceHostImageCopyProperties.__array((int)1, (int)16), VkPhysicalDeviceHostImageCopyProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COPYSRCLAYOUTCOUNT = layout.offsetof(2);
        PCOPYSRCLAYOUTS = layout.offsetof(3);
        COPYDSTLAYOUTCOUNT = layout.offsetof(4);
        PCOPYDSTLAYOUTS = layout.offsetof(5);
        OPTIMALTILINGLAYOUTUUID = layout.offsetof(6);
        IDENTICALMEMORYTYPEREQUIREMENTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceHostImageCopyProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceHostImageCopyProperties ELEMENT_FACTORY = VkPhysicalDeviceHostImageCopyProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPhysicalDeviceHostImageCopyProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceHostImageCopyProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceHostImageCopyProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int copySrcLayoutCount() {
            return VkPhysicalDeviceHostImageCopyProperties.ncopySrcLayoutCount(this.address());
        }

        @NativeType(value="VkImageLayout *")
        public @Nullable IntBuffer pCopySrcLayouts() {
            return VkPhysicalDeviceHostImageCopyProperties.npCopySrcLayouts(this.address());
        }

        @NativeType(value="uint32_t")
        public int copyDstLayoutCount() {
            return VkPhysicalDeviceHostImageCopyProperties.ncopyDstLayoutCount(this.address());
        }

        @NativeType(value="VkImageLayout *")
        public @Nullable IntBuffer pCopyDstLayouts() {
            return VkPhysicalDeviceHostImageCopyProperties.npCopyDstLayouts(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer optimalTilingLayoutUUID() {
            return VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte optimalTilingLayoutUUID(int index) {
            return VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address(), index);
        }

        @NativeType(value="VkBool32")
        public boolean identicalMemoryTypeRequirements() {
            return VkPhysicalDeviceHostImageCopyProperties.nidenticalMemoryTypeRequirements(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceHostImageCopyProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceHostImageCopyProperties.npNext(this.address(), value);
            return this;
        }

        public Buffer copySrcLayoutCount(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceHostImageCopyProperties.ncopySrcLayoutCount(this.address(), value);
            return this;
        }

        public Buffer pCopySrcLayouts(@NativeType(value="VkImageLayout *") @Nullable IntBuffer value) {
            VkPhysicalDeviceHostImageCopyProperties.npCopySrcLayouts(this.address(), value);
            return this;
        }

        public Buffer copyDstLayoutCount(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceHostImageCopyProperties.ncopyDstLayoutCount(this.address(), value);
            return this;
        }

        public Buffer pCopyDstLayouts(@NativeType(value="VkImageLayout *") @Nullable IntBuffer value) {
            VkPhysicalDeviceHostImageCopyProperties.npCopyDstLayouts(this.address(), value);
            return this;
        }

        public Buffer optimalTilingLayoutUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address(), value);
            return this;
        }

        public Buffer optimalTilingLayoutUUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPhysicalDeviceHostImageCopyProperties.noptimalTilingLayoutUUID(this.address(), index, value);
            return this;
        }

        public Buffer identicalMemoryTypeRequirements(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceHostImageCopyProperties.nidenticalMemoryTypeRequirements(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

