/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceIDProperties
extends Struct<VkPhysicalDeviceIDProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEUUID;
    public static final int DRIVERUUID;
    public static final int DEVICELUID;
    public static final int DEVICENODEMASK;
    public static final int DEVICELUIDVALID;

    protected VkPhysicalDeviceIDProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPhysicalDeviceIDProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceIDProperties(address, container);
    }

    public VkPhysicalDeviceIDProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceIDProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceIDProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceIDProperties.npNext(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer deviceUUID() {
        return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceUUID(int index) {
        return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer driverUUID() {
        return VkPhysicalDeviceIDProperties.ndriverUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte driverUUID(int index) {
        return VkPhysicalDeviceIDProperties.ndriverUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_LUID_SIZE]")
    public ByteBuffer deviceLUID() {
        return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceLUID(int index) {
        return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int deviceNodeMask() {
        return VkPhysicalDeviceIDProperties.ndeviceNodeMask(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean deviceLUIDValid() {
        return VkPhysicalDeviceIDProperties.ndeviceLUIDValid(this.address()) != 0;
    }

    public VkPhysicalDeviceIDProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceIDProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceIDProperties sType$Default() {
        return this.sType(1000071004);
    }

    public VkPhysicalDeviceIDProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceIDProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceIDProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceIDProperties set(VkPhysicalDeviceIDProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceIDProperties malloc() {
        return new VkPhysicalDeviceIDProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPhysicalDeviceIDProperties calloc() {
        return new VkPhysicalDeviceIDProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPhysicalDeviceIDProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPhysicalDeviceIDProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPhysicalDeviceIDProperties create(long address) {
        return new VkPhysicalDeviceIDProperties(address, null);
    }

    public static @Nullable VkPhysicalDeviceIDProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceIDProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceIDProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceIDProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceIDProperties mallocStack() {
        return VkPhysicalDeviceIDProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceIDProperties callocStack() {
        return VkPhysicalDeviceIDProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceIDProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceIDProperties.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceIDProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceIDProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceIDProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceIDProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceIDProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceIDProperties.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceIDProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceIDProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceIDProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceIDProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static ByteBuffer ndeviceUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICEUUID), (int)16);
    }

    public static byte ndeviceUUID(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)DEVICEUUID + Checks.check((int)index, (int)16) * 1L));
    }

    public static ByteBuffer ndriverUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERUUID), (int)16);
    }

    public static byte ndriverUUID(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)DRIVERUUID + Checks.check((int)index, (int)16) * 1L));
    }

    public static ByteBuffer ndeviceLUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICELUID), (int)8);
    }

    public static byte ndeviceLUID(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)DEVICELUID + Checks.check((int)index, (int)8) * 1L));
    }

    public static int ndeviceNodeMask(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEVICENODEMASK));
    }

    public static int ndeviceLUIDValid(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEVICELUIDVALID));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceIDProperties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceIDProperties.__member((int)4), VkPhysicalDeviceIDProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceIDProperties.__array((int)1, (int)16), VkPhysicalDeviceIDProperties.__array((int)1, (int)16), VkPhysicalDeviceIDProperties.__array((int)1, (int)8), VkPhysicalDeviceIDProperties.__member((int)4), VkPhysicalDeviceIDProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEUUID = layout.offsetof(2);
        DRIVERUUID = layout.offsetof(3);
        DEVICELUID = layout.offsetof(4);
        DEVICENODEMASK = layout.offsetof(5);
        DEVICELUIDVALID = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceIDProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceIDProperties ELEMENT_FACTORY = VkPhysicalDeviceIDProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPhysicalDeviceIDProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceIDProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceIDProperties.npNext(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer deviceUUID() {
            return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceUUID(int index) {
            return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer driverUUID() {
            return VkPhysicalDeviceIDProperties.ndriverUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte driverUUID(int index) {
            return VkPhysicalDeviceIDProperties.ndriverUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_LUID_SIZE]")
        public ByteBuffer deviceLUID() {
            return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceLUID(int index) {
            return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int deviceNodeMask() {
            return VkPhysicalDeviceIDProperties.ndeviceNodeMask(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean deviceLUIDValid() {
            return VkPhysicalDeviceIDProperties.ndeviceLUIDValid(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceIDProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000071004);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceIDProperties.npNext(this.address(), value);
            return this;
        }
    }
}

