/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineCacheHeaderVersionOne
extends Struct<VkPipelineCacheHeaderVersionOne>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADERSIZE;
    public static final int HEADERVERSION;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int PIPELINECACHEUUID;

    protected VkPipelineCacheHeaderVersionOne(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineCacheHeaderVersionOne create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineCacheHeaderVersionOne(address, container);
    }

    public VkPipelineCacheHeaderVersionOne(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineCacheHeaderVersionOne.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int headerSize() {
        return VkPipelineCacheHeaderVersionOne.nheaderSize(this.address());
    }

    @NativeType(value="VkPipelineCacheHeaderVersion")
    public int headerVersion() {
        return VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorID() {
        return VkPipelineCacheHeaderVersionOne.nvendorID(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceID() {
        return VkPipelineCacheHeaderVersionOne.ndeviceID(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer pipelineCacheUUID() {
        return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pipelineCacheUUID(int index) {
        return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index);
    }

    public VkPipelineCacheHeaderVersionOne headerSize(@NativeType(value="uint32_t") int value) {
        VkPipelineCacheHeaderVersionOne.nheaderSize(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne headerVersion(@NativeType(value="VkPipelineCacheHeaderVersion") int value) {
        VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne vendorID(@NativeType(value="uint32_t") int value) {
        VkPipelineCacheHeaderVersionOne.nvendorID(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne deviceID(@NativeType(value="uint32_t") int value) {
        VkPipelineCacheHeaderVersionOne.ndeviceID(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne pipelineCacheUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
        VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne pipelineCacheUUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index, value);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne set(int headerSize, int headerVersion, int vendorID, int deviceID, ByteBuffer pipelineCacheUUID) {
        this.headerSize(headerSize);
        this.headerVersion(headerVersion);
        this.vendorID(vendorID);
        this.deviceID(deviceID);
        this.pipelineCacheUUID(pipelineCacheUUID);
        return this;
    }

    public VkPipelineCacheHeaderVersionOne set(VkPipelineCacheHeaderVersionOne src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineCacheHeaderVersionOne malloc() {
        return new VkPipelineCacheHeaderVersionOne(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineCacheHeaderVersionOne calloc() {
        return new VkPipelineCacheHeaderVersionOne(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineCacheHeaderVersionOne create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineCacheHeaderVersionOne(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineCacheHeaderVersionOne create(long address) {
        return new VkPipelineCacheHeaderVersionOne(address, null);
    }

    public static @Nullable VkPipelineCacheHeaderVersionOne createSafe(long address) {
        return address == 0L ? null : new VkPipelineCacheHeaderVersionOne(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineCacheHeaderVersionOne.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineCacheHeaderVersionOne.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineCacheHeaderVersionOne malloc(MemoryStack stack) {
        return new VkPipelineCacheHeaderVersionOne(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineCacheHeaderVersionOne calloc(MemoryStack stack) {
        return new VkPipelineCacheHeaderVersionOne(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nheaderSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEADERSIZE));
    }

    public static int nheaderVersion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEADERVERSION));
    }

    public static int nvendorID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VENDORID));
    }

    public static int ndeviceID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEVICEID));
    }

    public static ByteBuffer npipelineCacheUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PIPELINECACHEUUID), (int)16);
    }

    public static byte npipelineCacheUUID(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)PIPELINECACHEUUID + Checks.check((int)index, (int)16) * 1L));
    }

    public static void nheaderSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEADERSIZE), (int)value);
    }

    public static void nheaderVersion(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEADERVERSION), (int)value);
    }

    public static void nvendorID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VENDORID), (int)value);
    }

    public static void ndeviceID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEVICEID), (int)value);
    }

    public static void npipelineCacheUUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)PIPELINECACHEUUID), (long)(value.remaining() * 1));
    }

    public static void npipelineCacheUUID(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PIPELINECACHEUUID + Checks.check((int)index, (int)16) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = VkPipelineCacheHeaderVersionOne.__struct((Struct.Member[])new Struct.Member[]{VkPipelineCacheHeaderVersionOne.__member((int)4), VkPipelineCacheHeaderVersionOne.__member((int)4), VkPipelineCacheHeaderVersionOne.__member((int)4), VkPipelineCacheHeaderVersionOne.__member((int)4), VkPipelineCacheHeaderVersionOne.__array((int)1, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADERSIZE = layout.offsetof(0);
        HEADERVERSION = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        PIPELINECACHEUUID = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineCacheHeaderVersionOne, Buffer>
    implements NativeResource {
        private static final VkPipelineCacheHeaderVersionOne ELEMENT_FACTORY = VkPipelineCacheHeaderVersionOne.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPipelineCacheHeaderVersionOne getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int headerSize() {
            return VkPipelineCacheHeaderVersionOne.nheaderSize(this.address());
        }

        @NativeType(value="VkPipelineCacheHeaderVersion")
        public int headerVersion() {
            return VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorID() {
            return VkPipelineCacheHeaderVersionOne.nvendorID(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceID() {
            return VkPipelineCacheHeaderVersionOne.ndeviceID(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer pipelineCacheUUID() {
            return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pipelineCacheUUID(int index) {
            return VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index);
        }

        public Buffer headerSize(@NativeType(value="uint32_t") int value) {
            VkPipelineCacheHeaderVersionOne.nheaderSize(this.address(), value);
            return this;
        }

        public Buffer headerVersion(@NativeType(value="VkPipelineCacheHeaderVersion") int value) {
            VkPipelineCacheHeaderVersionOne.nheaderVersion(this.address(), value);
            return this;
        }

        public Buffer vendorID(@NativeType(value="uint32_t") int value) {
            VkPipelineCacheHeaderVersionOne.nvendorID(this.address(), value);
            return this;
        }

        public Buffer deviceID(@NativeType(value="uint32_t") int value) {
            VkPipelineCacheHeaderVersionOne.ndeviceID(this.address(), value);
            return this;
        }

        public Buffer pipelineCacheUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
            VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), value);
            return this;
        }

        public Buffer pipelineCacheUUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPipelineCacheHeaderVersionOne.npipelineCacheUUID(this.address(), index, value);
            return this;
        }
    }
}

