/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineDynamicStateCreateInfo
extends Struct<VkPipelineDynamicStateCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DYNAMICSTATECOUNT;
    public static final int PDYNAMICSTATES;

    protected VkPipelineDynamicStateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineDynamicStateCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineDynamicStateCreateInfo(address, container);
    }

    public VkPipelineDynamicStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineDynamicStateCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineDynamicStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineDynamicStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineDynamicStateCreateFlags")
    public int flags() {
        return VkPipelineDynamicStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int dynamicStateCount() {
        return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
    }

    @NativeType(value="VkDynamicState const *")
    public @Nullable IntBuffer pDynamicStates() {
        return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
    }

    public VkPipelineDynamicStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo sType$Default() {
        return this.sType(27);
    }

    public VkPipelineDynamicStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo flags(@NativeType(value="VkPipelineDynamicStateCreateFlags") int value) {
        VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo pDynamicStates(@NativeType(value="VkDynamicState const *") @Nullable IntBuffer value) {
        VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(int sType, long pNext, int flags, @Nullable IntBuffer pDynamicStates) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pDynamicStates(pDynamicStates);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(VkPipelineDynamicStateCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineDynamicStateCreateInfo malloc() {
        return new VkPipelineDynamicStateCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineDynamicStateCreateInfo calloc() {
        return new VkPipelineDynamicStateCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineDynamicStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineDynamicStateCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineDynamicStateCreateInfo create(long address) {
        return new VkPipelineDynamicStateCreateInfo(address, null);
    }

    public static @Nullable VkPipelineDynamicStateCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineDynamicStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineDynamicStateCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineDynamicStateCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo mallocStack() {
        return VkPipelineDynamicStateCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo callocStack() {
        return VkPipelineDynamicStateCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineDynamicStateCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineDynamicStateCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineDynamicStateCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineDynamicStateCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int ndynamicStateCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DYNAMICSTATECOUNT));
    }

    public static @Nullable IntBuffer npDynamicStates(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDYNAMICSTATES)), (int)VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void ndynamicStateCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DYNAMICSTATECOUNT), (int)value);
    }

    public static void npDynamicStates(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDYNAMICSTATES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDYNAMICSTATES)));
        }
    }

    static {
        Struct.Layout layout = VkPipelineDynamicStateCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineDynamicStateCreateInfo.__member((int)4), VkPipelineDynamicStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineDynamicStateCreateInfo.__member((int)4), VkPipelineDynamicStateCreateInfo.__member((int)4), VkPipelineDynamicStateCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DYNAMICSTATECOUNT = layout.offsetof(3);
        PDYNAMICSTATES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineDynamicStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineDynamicStateCreateInfo ELEMENT_FACTORY = VkPipelineDynamicStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPipelineDynamicStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineDynamicStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineDynamicStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineDynamicStateCreateFlags")
        public int flags() {
            return VkPipelineDynamicStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int dynamicStateCount() {
            return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
        }

        @NativeType(value="VkDynamicState const *")
        public @Nullable IntBuffer pDynamicStates() {
            return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(27);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineDynamicStateCreateFlags") int value) {
            VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pDynamicStates(@NativeType(value="VkDynamicState const *") @Nullable IntBuffer value) {
            VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
            return this;
        }
    }
}

