/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineLibraryCreateInfoKHR
extends Struct<VkPipelineLibraryCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int LIBRARYCOUNT;
    public static final int PLIBRARIES;

    protected VkPipelineLibraryCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineLibraryCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineLibraryCreateInfoKHR(address, container);
    }

    public VkPipelineLibraryCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineLibraryCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineLibraryCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineLibraryCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int libraryCount() {
        return VkPipelineLibraryCreateInfoKHR.nlibraryCount(this.address());
    }

    @NativeType(value="VkPipeline const *")
    public @Nullable LongBuffer pLibraries() {
        return VkPipelineLibraryCreateInfoKHR.npLibraries(this.address());
    }

    public VkPipelineLibraryCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineLibraryCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineLibraryCreateInfoKHR sType$Default() {
        return this.sType(1000290000);
    }

    public VkPipelineLibraryCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineLibraryCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineLibraryCreateInfoKHR pLibraries(@NativeType(value="VkPipeline const *") @Nullable LongBuffer value) {
        VkPipelineLibraryCreateInfoKHR.npLibraries(this.address(), value);
        return this;
    }

    public VkPipelineLibraryCreateInfoKHR set(int sType, long pNext, @Nullable LongBuffer pLibraries) {
        this.sType(sType);
        this.pNext(pNext);
        this.pLibraries(pLibraries);
        return this;
    }

    public VkPipelineLibraryCreateInfoKHR set(VkPipelineLibraryCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineLibraryCreateInfoKHR malloc() {
        return new VkPipelineLibraryCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineLibraryCreateInfoKHR calloc() {
        return new VkPipelineLibraryCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineLibraryCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineLibraryCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineLibraryCreateInfoKHR create(long address) {
        return new VkPipelineLibraryCreateInfoKHR(address, null);
    }

    public static @Nullable VkPipelineLibraryCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineLibraryCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineLibraryCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineLibraryCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineLibraryCreateInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineLibraryCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineLibraryCreateInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineLibraryCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nlibraryCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LIBRARYCOUNT));
    }

    public static @Nullable LongBuffer npLibraries(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PLIBRARIES)), (int)VkPipelineLibraryCreateInfoKHR.nlibraryCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nlibraryCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LIBRARYCOUNT), (int)value);
    }

    public static void npLibraries(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLIBRARIES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkPipelineLibraryCreateInfoKHR.nlibraryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineLibraryCreateInfoKHR.nlibraryCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLIBRARIES)));
        }
    }

    static {
        Struct.Layout layout = VkPipelineLibraryCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkPipelineLibraryCreateInfoKHR.__member((int)4), VkPipelineLibraryCreateInfoKHR.__member((int)POINTER_SIZE), VkPipelineLibraryCreateInfoKHR.__member((int)4), VkPipelineLibraryCreateInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        LIBRARYCOUNT = layout.offsetof(2);
        PLIBRARIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineLibraryCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineLibraryCreateInfoKHR ELEMENT_FACTORY = VkPipelineLibraryCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPipelineLibraryCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineLibraryCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineLibraryCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int libraryCount() {
            return VkPipelineLibraryCreateInfoKHR.nlibraryCount(this.address());
        }

        @NativeType(value="VkPipeline const *")
        public @Nullable LongBuffer pLibraries() {
            return VkPipelineLibraryCreateInfoKHR.npLibraries(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineLibraryCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000290000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineLibraryCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pLibraries(@NativeType(value="VkPipeline const *") @Nullable LongBuffer value) {
            VkPipelineLibraryCreateInfoKHR.npLibraries(this.address(), value);
            return this;
        }
    }
}

