/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;

public class VkPushConstantsInfo
extends Struct<VkPushConstantsInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int LAYOUT;
    public static final int STAGEFLAGS;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PVALUES;

    protected VkPushConstantsInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPushConstantsInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPushConstantsInfo(address, container);
    }

    public VkPushConstantsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPushConstantsInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPushConstantsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPushConstantsInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkPushConstantsInfo.nlayout(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushConstantsInfo.nstageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkPushConstantsInfo.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkPushConstantsInfo.nsize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pValues() {
        return VkPushConstantsInfo.npValues(this.address());
    }

    public VkPushConstantsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPushConstantsInfo.nsType(this.address(), value);
        return this;
    }

    public VkPushConstantsInfo sType$Default() {
        return this.sType(1000545004);
    }

    public VkPushConstantsInfo pNext(@NativeType(value="void const *") long value) {
        VkPushConstantsInfo.npNext(this.address(), value);
        return this;
    }

    public VkPushConstantsInfo pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPushConstantsInfo layout(@NativeType(value="VkPipelineLayout") long value) {
        VkPushConstantsInfo.nlayout(this.address(), value);
        return this;
    }

    public VkPushConstantsInfo stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushConstantsInfo.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushConstantsInfo offset(@NativeType(value="uint32_t") int value) {
        VkPushConstantsInfo.noffset(this.address(), value);
        return this;
    }

    public VkPushConstantsInfo pValues(@NativeType(value="void const *") ByteBuffer value) {
        VkPushConstantsInfo.npValues(this.address(), value);
        return this;
    }

    public VkPushConstantsInfo set(int sType, long pNext, long layout, int stageFlags, int offset, ByteBuffer pValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.layout(layout);
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.pValues(pValues);
        return this;
    }

    public VkPushConstantsInfo set(VkPushConstantsInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPushConstantsInfo malloc() {
        return new VkPushConstantsInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPushConstantsInfo calloc() {
        return new VkPushConstantsInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPushConstantsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPushConstantsInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPushConstantsInfo create(long address) {
        return new VkPushConstantsInfo(address, null);
    }

    public static @Nullable VkPushConstantsInfo createSafe(long address) {
        return address == 0L ? null : new VkPushConstantsInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPushConstantsInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushConstantsInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPushConstantsInfo malloc(MemoryStack stack) {
        return new VkPushConstantsInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPushConstantsInfo calloc(MemoryStack stack) {
        return new VkPushConstantsInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LAYOUT));
    }

    public static int nstageFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STAGEFLAGS));
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OFFSET));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static ByteBuffer npValues(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)), (int)VkPushConstantsInfo.nsize(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)LAYOUT), (long)value);
    }

    public static void nstageFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STAGEFLAGS), (int)value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OFFSET), (int)value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void npValues(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVALUES), (long)MemoryUtil.memAddress((ByteBuffer)value));
        VkPushConstantsInfo.nsize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)));
    }

    static {
        Struct.Layout layout = VkPushConstantsInfo.__struct((Struct.Member[])new Struct.Member[]{VkPushConstantsInfo.__member((int)4), VkPushConstantsInfo.__member((int)POINTER_SIZE), VkPushConstantsInfo.__member((int)8), VkPushConstantsInfo.__member((int)4), VkPushConstantsInfo.__member((int)4), VkPushConstantsInfo.__member((int)4), VkPushConstantsInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        LAYOUT = layout.offsetof(2);
        STAGEFLAGS = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
        PVALUES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPushConstantsInfo, Buffer>
    implements NativeResource {
        private static final VkPushConstantsInfo ELEMENT_FACTORY = VkPushConstantsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPushConstantsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPushConstantsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPushConstantsInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkPushConstantsInfo.nlayout(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushConstantsInfo.nstageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkPushConstantsInfo.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkPushConstantsInfo.nsize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pValues() {
            return VkPushConstantsInfo.npValues(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPushConstantsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPushConstantsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkPushConstantsInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushConstantsInfo.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkPushConstantsInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer pValues(@NativeType(value="void const *") ByteBuffer value) {
            VkPushConstantsInfo.npValues(this.address(), value);
            return this;
        }
    }
}

