/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;
import org.lwjgl.vulkan.VkWriteDescriptorSet;

public class VkPushDescriptorSetInfo
extends Struct<VkPushDescriptorSetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGEFLAGS;
    public static final int LAYOUT;
    public static final int SET;
    public static final int DESCRIPTORWRITECOUNT;
    public static final int PDESCRIPTORWRITES;

    protected VkPushDescriptorSetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPushDescriptorSetInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPushDescriptorSetInfo(address, container);
    }

    public VkPushDescriptorSetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPushDescriptorSetInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPushDescriptorSetInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPushDescriptorSetInfo.npNext(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushDescriptorSetInfo.nstageFlags(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkPushDescriptorSetInfo.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int set() {
        return VkPushDescriptorSetInfo.nset(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorWriteCount() {
        return VkPushDescriptorSetInfo.ndescriptorWriteCount(this.address());
    }

    @NativeType(value="VkWriteDescriptorSet const *")
    public VkWriteDescriptorSet.Buffer pDescriptorWrites() {
        return VkPushDescriptorSetInfo.npDescriptorWrites(this.address());
    }

    public VkPushDescriptorSetInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPushDescriptorSetInfo.nsType(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfo sType$Default() {
        return this.sType(1000545005);
    }

    public VkPushDescriptorSetInfo pNext(@NativeType(value="void const *") long value) {
        VkPushDescriptorSetInfo.npNext(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfo pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPushDescriptorSetInfo stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushDescriptorSetInfo.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfo layout(@NativeType(value="VkPipelineLayout") long value) {
        VkPushDescriptorSetInfo.nlayout(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfo set(@NativeType(value="uint32_t") int value) {
        VkPushDescriptorSetInfo.nset(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfo pDescriptorWrites(@NativeType(value="VkWriteDescriptorSet const *") VkWriteDescriptorSet.Buffer value) {
        VkPushDescriptorSetInfo.npDescriptorWrites(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfo set(int sType, long pNext, int stageFlags, long layout, int set, VkWriteDescriptorSet.Buffer pDescriptorWrites) {
        this.sType(sType);
        this.pNext(pNext);
        this.stageFlags(stageFlags);
        this.layout(layout);
        this.set(set);
        this.pDescriptorWrites(pDescriptorWrites);
        return this;
    }

    public VkPushDescriptorSetInfo set(VkPushDescriptorSetInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPushDescriptorSetInfo malloc() {
        return new VkPushDescriptorSetInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPushDescriptorSetInfo calloc() {
        return new VkPushDescriptorSetInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPushDescriptorSetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPushDescriptorSetInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPushDescriptorSetInfo create(long address) {
        return new VkPushDescriptorSetInfo(address, null);
    }

    public static @Nullable VkPushDescriptorSetInfo createSafe(long address) {
        return address == 0L ? null : new VkPushDescriptorSetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPushDescriptorSetInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushDescriptorSetInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPushDescriptorSetInfo malloc(MemoryStack stack) {
        return new VkPushDescriptorSetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPushDescriptorSetInfo calloc(MemoryStack stack) {
        return new VkPushDescriptorSetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nstageFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STAGEFLAGS));
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LAYOUT));
    }

    public static int nset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SET));
    }

    public static int ndescriptorWriteCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DESCRIPTORWRITECOUNT));
    }

    public static VkWriteDescriptorSet.Buffer npDescriptorWrites(long struct) {
        return VkWriteDescriptorSet.create(MemoryUtil.memGetAddress((long)(struct + (long)PDESCRIPTORWRITES)), VkPushDescriptorSetInfo.ndescriptorWriteCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nstageFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STAGEFLAGS), (int)value);
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)LAYOUT), (long)value);
    }

    public static void nset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SET), (int)value);
    }

    public static void ndescriptorWriteCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DESCRIPTORWRITECOUNT), (int)value);
    }

    public static void npDescriptorWrites(long struct, VkWriteDescriptorSet.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDESCRIPTORWRITES), (long)value.address());
        VkPushDescriptorSetInfo.ndescriptorWriteCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDESCRIPTORWRITES)));
    }

    static {
        Struct.Layout layout = VkPushDescriptorSetInfo.__struct((Struct.Member[])new Struct.Member[]{VkPushDescriptorSetInfo.__member((int)4), VkPushDescriptorSetInfo.__member((int)POINTER_SIZE), VkPushDescriptorSetInfo.__member((int)4), VkPushDescriptorSetInfo.__member((int)8), VkPushDescriptorSetInfo.__member((int)4), VkPushDescriptorSetInfo.__member((int)4), VkPushDescriptorSetInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGEFLAGS = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        SET = layout.offsetof(4);
        DESCRIPTORWRITECOUNT = layout.offsetof(5);
        PDESCRIPTORWRITES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPushDescriptorSetInfo, Buffer>
    implements NativeResource {
        private static final VkPushDescriptorSetInfo ELEMENT_FACTORY = VkPushDescriptorSetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPushDescriptorSetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPushDescriptorSetInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPushDescriptorSetInfo.npNext(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushDescriptorSetInfo.nstageFlags(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkPushDescriptorSetInfo.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int set() {
            return VkPushDescriptorSetInfo.nset(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorWriteCount() {
            return VkPushDescriptorSetInfo.ndescriptorWriteCount(this.address());
        }

        @NativeType(value="VkWriteDescriptorSet const *")
        public VkWriteDescriptorSet.Buffer pDescriptorWrites() {
            return VkPushDescriptorSetInfo.npDescriptorWrites(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPushDescriptorSetInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPushDescriptorSetInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushDescriptorSetInfo.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkPushDescriptorSetInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer set(@NativeType(value="uint32_t") int value) {
            VkPushDescriptorSetInfo.nset(this.address(), value);
            return this;
        }

        public Buffer pDescriptorWrites(@NativeType(value="VkWriteDescriptorSet const *") VkWriteDescriptorSet.Buffer value) {
            VkPushDescriptorSetInfo.npDescriptorWrites(this.address(), value);
            return this;
        }
    }
}

