/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkQueueFamilyProperties
extends Struct<VkQueueFamilyProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int QUEUEFLAGS;
    public static final int QUEUECOUNT;
    public static final int TIMESTAMPVALIDBITS;
    public static final int MINIMAGETRANSFERGRANULARITY;

    protected VkQueueFamilyProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkQueueFamilyProperties create(long address, @Nullable ByteBuffer container) {
        return new VkQueueFamilyProperties(address, container);
    }

    public VkQueueFamilyProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkQueueFamilyProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkQueueFlags")
    public int queueFlags() {
        return VkQueueFamilyProperties.nqueueFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueCount() {
        return VkQueueFamilyProperties.nqueueCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int timestampValidBits() {
        return VkQueueFamilyProperties.ntimestampValidBits(this.address());
    }

    public VkExtent3D minImageTransferGranularity() {
        return VkQueueFamilyProperties.nminImageTransferGranularity(this.address());
    }

    public static VkQueueFamilyProperties malloc() {
        return new VkQueueFamilyProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkQueueFamilyProperties calloc() {
        return new VkQueueFamilyProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkQueueFamilyProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkQueueFamilyProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkQueueFamilyProperties create(long address) {
        return new VkQueueFamilyProperties(address, null);
    }

    public static @Nullable VkQueueFamilyProperties createSafe(long address) {
        return address == 0L ? null : new VkQueueFamilyProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkQueueFamilyProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkQueueFamilyProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkQueueFamilyProperties mallocStack() {
        return VkQueueFamilyProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkQueueFamilyProperties callocStack() {
        return VkQueueFamilyProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkQueueFamilyProperties mallocStack(MemoryStack stack) {
        return VkQueueFamilyProperties.malloc(stack);
    }

    @Deprecated
    public static VkQueueFamilyProperties callocStack(MemoryStack stack) {
        return VkQueueFamilyProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkQueueFamilyProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkQueueFamilyProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkQueueFamilyProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkQueueFamilyProperties.calloc(capacity, stack);
    }

    public static VkQueueFamilyProperties malloc(MemoryStack stack) {
        return new VkQueueFamilyProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkQueueFamilyProperties calloc(MemoryStack stack) {
        return new VkQueueFamilyProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nqueueFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUEFLAGS));
    }

    public static int nqueueCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUECOUNT));
    }

    public static int ntimestampValidBits(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TIMESTAMPVALIDBITS));
    }

    public static VkExtent3D nminImageTransferGranularity(long struct) {
        return VkExtent3D.create(struct + (long)MINIMAGETRANSFERGRANULARITY);
    }

    static {
        Struct.Layout layout = VkQueueFamilyProperties.__struct((Struct.Member[])new Struct.Member[]{VkQueueFamilyProperties.__member((int)4), VkQueueFamilyProperties.__member((int)4), VkQueueFamilyProperties.__member((int)4), VkQueueFamilyProperties.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        QUEUEFLAGS = layout.offsetof(0);
        QUEUECOUNT = layout.offsetof(1);
        TIMESTAMPVALIDBITS = layout.offsetof(2);
        MINIMAGETRANSFERGRANULARITY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkQueueFamilyProperties, Buffer>
    implements NativeResource {
        private static final VkQueueFamilyProperties ELEMENT_FACTORY = VkQueueFamilyProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkQueueFamilyProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkQueueFlags")
        public int queueFlags() {
            return VkQueueFamilyProperties.nqueueFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueCount() {
            return VkQueueFamilyProperties.nqueueCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int timestampValidBits() {
            return VkQueueFamilyProperties.ntimestampValidBits(this.address());
        }

        public VkExtent3D minImageTransferGranularity() {
            return VkQueueFamilyProperties.nminImageTransferGranularity(this.address());
        }
    }
}

