/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineBinaryInfoKHR;
import org.lwjgl.vulkan.VkPipelineCreateFlags2CreateInfo;
import org.lwjgl.vulkan.VkPipelineCreateFlags2CreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfo;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineDynamicStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineLibraryCreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineRobustnessCreateInfo;
import org.lwjgl.vulkan.VkPipelineRobustnessCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkRayTracingPipelineInterfaceCreateInfoKHR;
import org.lwjgl.vulkan.VkRayTracingShaderGroupCreateInfoKHR;

public class VkRayTracingPipelineCreateInfoKHR
extends Struct<VkRayTracingPipelineCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGECOUNT;
    public static final int PSTAGES;
    public static final int GROUPCOUNT;
    public static final int PGROUPS;
    public static final int MAXPIPELINERAYRECURSIONDEPTH;
    public static final int PLIBRARYINFO;
    public static final int PLIBRARYINTERFACE;
    public static final int PDYNAMICSTATE;
    public static final int LAYOUT;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    protected VkRayTracingPipelineCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkRayTracingPipelineCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkRayTracingPipelineCreateInfoKHR(address, container);
    }

    public VkRayTracingPipelineCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRayTracingPipelineCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRayTracingPipelineCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRayTracingPipelineCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkPipelineCreateFlags")
    public int flags() {
        return VkRayTracingPipelineCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int stageCount() {
        return VkRayTracingPipelineCreateInfoKHR.nstageCount(this.address());
    }

    @NativeType(value="VkPipelineShaderStageCreateInfo const *")
    public @Nullable VkPipelineShaderStageCreateInfo.Buffer pStages() {
        return VkRayTracingPipelineCreateInfoKHR.npStages(this.address());
    }

    @NativeType(value="uint32_t")
    public int groupCount() {
        return VkRayTracingPipelineCreateInfoKHR.ngroupCount(this.address());
    }

    @NativeType(value="VkRayTracingShaderGroupCreateInfoKHR const *")
    public @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer pGroups() {
        return VkRayTracingPipelineCreateInfoKHR.npGroups(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPipelineRayRecursionDepth() {
        return VkRayTracingPipelineCreateInfoKHR.nmaxPipelineRayRecursionDepth(this.address());
    }

    @NativeType(value="VkPipelineLibraryCreateInfoKHR const *")
    public @Nullable VkPipelineLibraryCreateInfoKHR pLibraryInfo() {
        return VkRayTracingPipelineCreateInfoKHR.npLibraryInfo(this.address());
    }

    @NativeType(value="VkRayTracingPipelineInterfaceCreateInfoKHR const *")
    public @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR pLibraryInterface() {
        return VkRayTracingPipelineCreateInfoKHR.npLibraryInterface(this.address());
    }

    @NativeType(value="VkPipelineDynamicStateCreateInfo const *")
    public @Nullable VkPipelineDynamicStateCreateInfo pDynamicState() {
        return VkRayTracingPipelineCreateInfoKHR.npDynamicState(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkRayTracingPipelineCreateInfoKHR.nlayout(this.address());
    }

    @NativeType(value="VkPipeline")
    public long basePipelineHandle() {
        return VkRayTracingPipelineCreateInfoKHR.nbasePipelineHandle(this.address());
    }

    @NativeType(value="int32_t")
    public int basePipelineIndex() {
        return VkRayTracingPipelineCreateInfoKHR.nbasePipelineIndex(this.address());
    }

    public VkRayTracingPipelineCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRayTracingPipelineCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR sType$Default() {
        return this.sType(1000150015);
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRayTracingPipelineCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineBinaryInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineCreateFlags2CreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineCreateFlags2CreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineCreationFeedbackCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineRobustnessCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR pNext(VkPipelineRobustnessCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoKHR flags(@NativeType(value="VkPipelineCreateFlags") int value) {
        VkRayTracingPipelineCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") @Nullable VkPipelineShaderStageCreateInfo.Buffer value) {
        VkRayTracingPipelineCreateInfoKHR.npStages(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR pGroups(@NativeType(value="VkRayTracingShaderGroupCreateInfoKHR const *") @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer value) {
        VkRayTracingPipelineCreateInfoKHR.npGroups(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR maxPipelineRayRecursionDepth(@NativeType(value="uint32_t") int value) {
        VkRayTracingPipelineCreateInfoKHR.nmaxPipelineRayRecursionDepth(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR pLibraryInfo(@NativeType(value="VkPipelineLibraryCreateInfoKHR const *") @Nullable VkPipelineLibraryCreateInfoKHR value) {
        VkRayTracingPipelineCreateInfoKHR.npLibraryInfo(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR pLibraryInterface(@NativeType(value="VkRayTracingPipelineInterfaceCreateInfoKHR const *") @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR value) {
        VkRayTracingPipelineCreateInfoKHR.npLibraryInterface(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR pDynamicState(@NativeType(value="VkPipelineDynamicStateCreateInfo const *") @Nullable VkPipelineDynamicStateCreateInfo value) {
        VkRayTracingPipelineCreateInfoKHR.npDynamicState(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR layout(@NativeType(value="VkPipelineLayout") long value) {
        VkRayTracingPipelineCreateInfoKHR.nlayout(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR basePipelineHandle(@NativeType(value="VkPipeline") long value) {
        VkRayTracingPipelineCreateInfoKHR.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR basePipelineIndex(@NativeType(value="int32_t") int value) {
        VkRayTracingPipelineCreateInfoKHR.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR set(int sType, long pNext, int flags, @Nullable VkPipelineShaderStageCreateInfo.Buffer pStages, @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer pGroups, int maxPipelineRayRecursionDepth, @Nullable VkPipelineLibraryCreateInfoKHR pLibraryInfo, @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR pLibraryInterface, @Nullable VkPipelineDynamicStateCreateInfo pDynamicState, long layout, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pStages(pStages);
        this.pGroups(pGroups);
        this.maxPipelineRayRecursionDepth(maxPipelineRayRecursionDepth);
        this.pLibraryInfo(pLibraryInfo);
        this.pLibraryInterface(pLibraryInterface);
        this.pDynamicState(pDynamicState);
        this.layout(layout);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkRayTracingPipelineCreateInfoKHR set(VkRayTracingPipelineCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRayTracingPipelineCreateInfoKHR malloc() {
        return new VkRayTracingPipelineCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRayTracingPipelineCreateInfoKHR calloc() {
        return new VkRayTracingPipelineCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRayTracingPipelineCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRayTracingPipelineCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRayTracingPipelineCreateInfoKHR create(long address) {
        return new VkRayTracingPipelineCreateInfoKHR(address, null);
    }

    public static @Nullable VkRayTracingPipelineCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkRayTracingPipelineCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRayTracingPipelineCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRayTracingPipelineCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRayTracingPipelineCreateInfoKHR malloc(MemoryStack stack) {
        return new VkRayTracingPipelineCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRayTracingPipelineCreateInfoKHR calloc(MemoryStack stack) {
        return new VkRayTracingPipelineCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nstageCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STAGECOUNT));
    }

    public static @Nullable VkPipelineShaderStageCreateInfo.Buffer npStages(long struct) {
        return VkPipelineShaderStageCreateInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSTAGES)), VkRayTracingPipelineCreateInfoKHR.nstageCount(struct));
    }

    public static int ngroupCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GROUPCOUNT));
    }

    public static @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer npGroups(long struct) {
        return VkRayTracingShaderGroupCreateInfoKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PGROUPS)), VkRayTracingPipelineCreateInfoKHR.ngroupCount(struct));
    }

    public static int nmaxPipelineRayRecursionDepth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXPIPELINERAYRECURSIONDEPTH));
    }

    public static @Nullable VkPipelineLibraryCreateInfoKHR npLibraryInfo(long struct) {
        return VkPipelineLibraryCreateInfoKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PLIBRARYINFO)));
    }

    public static @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR npLibraryInterface(long struct) {
        return VkRayTracingPipelineInterfaceCreateInfoKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PLIBRARYINTERFACE)));
    }

    public static @Nullable VkPipelineDynamicStateCreateInfo npDynamicState(long struct) {
        return VkPipelineDynamicStateCreateInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDYNAMICSTATE)));
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LAYOUT));
    }

    public static long nbasePipelineHandle(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BASEPIPELINEHANDLE));
    }

    public static int nbasePipelineIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BASEPIPELINEINDEX));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nstageCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STAGECOUNT), (int)value);
    }

    public static void npStages(long struct, @Nullable VkPipelineShaderStageCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTAGES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRayTracingPipelineCreateInfoKHR.nstageCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ngroupCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GROUPCOUNT), (int)value);
    }

    public static void npGroups(long struct, @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PGROUPS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRayTracingPipelineCreateInfoKHR.ngroupCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nmaxPipelineRayRecursionDepth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXPIPELINERAYRECURSIONDEPTH), (int)value);
    }

    public static void npLibraryInfo(long struct, @Nullable VkPipelineLibraryCreateInfoKHR value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLIBRARYINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npLibraryInterface(long struct, @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLIBRARYINTERFACE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npDynamicState(long struct, @Nullable VkPipelineDynamicStateCreateInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDYNAMICSTATE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)LAYOUT), (long)value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BASEPIPELINEHANDLE), (long)value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BASEPIPELINEINDEX), (int)value);
    }

    public static void validate(long struct) {
        long pDynamicState;
        long pLibraryInfo;
        int stageCount = VkRayTracingPipelineCreateInfoKHR.nstageCount(struct);
        if (stageCount != 0) {
            long pStages = MemoryUtil.memGetAddress((long)(struct + (long)PSTAGES));
            Checks.check((long)pStages);
            VkRayTracingPipelineCreateInfoKHR.validate((long)pStages, (int)stageCount, (int)VkPipelineShaderStageCreateInfo.SIZEOF, VkPipelineShaderStageCreateInfo::validate);
        }
        if (VkRayTracingPipelineCreateInfoKHR.ngroupCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PGROUPS)));
        }
        if ((pLibraryInfo = MemoryUtil.memGetAddress((long)(struct + (long)PLIBRARYINFO))) != 0L) {
            VkPipelineLibraryCreateInfoKHR.validate(pLibraryInfo);
        }
        if ((pDynamicState = MemoryUtil.memGetAddress((long)(struct + (long)PDYNAMICSTATE))) != 0L) {
            VkPipelineDynamicStateCreateInfo.validate(pDynamicState);
        }
    }

    static {
        Struct.Layout layout = VkRayTracingPipelineCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkRayTracingPipelineCreateInfoKHR.__member((int)4), VkRayTracingPipelineCreateInfoKHR.__member((int)POINTER_SIZE), VkRayTracingPipelineCreateInfoKHR.__member((int)4), VkRayTracingPipelineCreateInfoKHR.__member((int)4), VkRayTracingPipelineCreateInfoKHR.__member((int)POINTER_SIZE), VkRayTracingPipelineCreateInfoKHR.__member((int)4), VkRayTracingPipelineCreateInfoKHR.__member((int)POINTER_SIZE), VkRayTracingPipelineCreateInfoKHR.__member((int)4), VkRayTracingPipelineCreateInfoKHR.__member((int)POINTER_SIZE), VkRayTracingPipelineCreateInfoKHR.__member((int)POINTER_SIZE), VkRayTracingPipelineCreateInfoKHR.__member((int)POINTER_SIZE), VkRayTracingPipelineCreateInfoKHR.__member((int)8), VkRayTracingPipelineCreateInfoKHR.__member((int)8), VkRayTracingPipelineCreateInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGECOUNT = layout.offsetof(3);
        PSTAGES = layout.offsetof(4);
        GROUPCOUNT = layout.offsetof(5);
        PGROUPS = layout.offsetof(6);
        MAXPIPELINERAYRECURSIONDEPTH = layout.offsetof(7);
        PLIBRARYINFO = layout.offsetof(8);
        PLIBRARYINTERFACE = layout.offsetof(9);
        PDYNAMICSTATE = layout.offsetof(10);
        LAYOUT = layout.offsetof(11);
        BASEPIPELINEHANDLE = layout.offsetof(12);
        BASEPIPELINEINDEX = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<VkRayTracingPipelineCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkRayTracingPipelineCreateInfoKHR ELEMENT_FACTORY = VkRayTracingPipelineCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkRayTracingPipelineCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRayTracingPipelineCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRayTracingPipelineCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkPipelineCreateFlags")
        public int flags() {
            return VkRayTracingPipelineCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int stageCount() {
            return VkRayTracingPipelineCreateInfoKHR.nstageCount(this.address());
        }

        @NativeType(value="VkPipelineShaderStageCreateInfo const *")
        public @Nullable VkPipelineShaderStageCreateInfo.Buffer pStages() {
            return VkRayTracingPipelineCreateInfoKHR.npStages(this.address());
        }

        @NativeType(value="uint32_t")
        public int groupCount() {
            return VkRayTracingPipelineCreateInfoKHR.ngroupCount(this.address());
        }

        @NativeType(value="VkRayTracingShaderGroupCreateInfoKHR const *")
        public @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer pGroups() {
            return VkRayTracingPipelineCreateInfoKHR.npGroups(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPipelineRayRecursionDepth() {
            return VkRayTracingPipelineCreateInfoKHR.nmaxPipelineRayRecursionDepth(this.address());
        }

        @NativeType(value="VkPipelineLibraryCreateInfoKHR const *")
        public @Nullable VkPipelineLibraryCreateInfoKHR pLibraryInfo() {
            return VkRayTracingPipelineCreateInfoKHR.npLibraryInfo(this.address());
        }

        @NativeType(value="VkRayTracingPipelineInterfaceCreateInfoKHR const *")
        public @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR pLibraryInterface() {
            return VkRayTracingPipelineCreateInfoKHR.npLibraryInterface(this.address());
        }

        @NativeType(value="VkPipelineDynamicStateCreateInfo const *")
        public @Nullable VkPipelineDynamicStateCreateInfo pDynamicState() {
            return VkRayTracingPipelineCreateInfoKHR.npDynamicState(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkRayTracingPipelineCreateInfoKHR.nlayout(this.address());
        }

        @NativeType(value="VkPipeline")
        public long basePipelineHandle() {
            return VkRayTracingPipelineCreateInfoKHR.nbasePipelineHandle(this.address());
        }

        @NativeType(value="int32_t")
        public int basePipelineIndex() {
            return VkRayTracingPipelineCreateInfoKHR.nbasePipelineIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRayTracingPipelineCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150015);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRayTracingPipelineCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineBinaryInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreateFlags2CreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreateFlags2CreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRobustnessCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineRobustnessCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineCreateFlags") int value) {
            VkRayTracingPipelineCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") @Nullable VkPipelineShaderStageCreateInfo.Buffer value) {
            VkRayTracingPipelineCreateInfoKHR.npStages(this.address(), value);
            return this;
        }

        public Buffer pGroups(@NativeType(value="VkRayTracingShaderGroupCreateInfoKHR const *") @Nullable VkRayTracingShaderGroupCreateInfoKHR.Buffer value) {
            VkRayTracingPipelineCreateInfoKHR.npGroups(this.address(), value);
            return this;
        }

        public Buffer maxPipelineRayRecursionDepth(@NativeType(value="uint32_t") int value) {
            VkRayTracingPipelineCreateInfoKHR.nmaxPipelineRayRecursionDepth(this.address(), value);
            return this;
        }

        public Buffer pLibraryInfo(@NativeType(value="VkPipelineLibraryCreateInfoKHR const *") @Nullable VkPipelineLibraryCreateInfoKHR value) {
            VkRayTracingPipelineCreateInfoKHR.npLibraryInfo(this.address(), value);
            return this;
        }

        public Buffer pLibraryInterface(@NativeType(value="VkRayTracingPipelineInterfaceCreateInfoKHR const *") @Nullable VkRayTracingPipelineInterfaceCreateInfoKHR value) {
            VkRayTracingPipelineCreateInfoKHR.npLibraryInterface(this.address(), value);
            return this;
        }

        public Buffer pDynamicState(@NativeType(value="VkPipelineDynamicStateCreateInfo const *") @Nullable VkPipelineDynamicStateCreateInfo value) {
            VkRayTracingPipelineCreateInfoKHR.npDynamicState(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkRayTracingPipelineCreateInfoKHR.nlayout(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(@NativeType(value="VkPipeline") long value) {
            VkRayTracingPipelineCreateInfoKHR.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(@NativeType(value="int32_t") int value) {
            VkRayTracingPipelineCreateInfoKHR.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

