/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentDescription2;
import org.lwjgl.vulkan.VkRenderPassCreationControlEXT;
import org.lwjgl.vulkan.VkRenderPassCreationFeedbackCreateInfoEXT;
import org.lwjgl.vulkan.VkRenderPassFragmentDensityMapCreateInfoEXT;
import org.lwjgl.vulkan.VkSubpassDependency2;
import org.lwjgl.vulkan.VkSubpassDescription2;

public class VkRenderPassCreateInfo2
extends Struct<VkRenderPassCreateInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int SUBPASSCOUNT;
    public static final int PSUBPASSES;
    public static final int DEPENDENCYCOUNT;
    public static final int PDEPENDENCIES;
    public static final int CORRELATEDVIEWMASKCOUNT;
    public static final int PCORRELATEDVIEWMASKS;

    protected VkRenderPassCreateInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkRenderPassCreateInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassCreateInfo2(address, container);
    }

    public VkRenderPassCreateInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassCreateInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassCreateInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassCreateInfo2.npNext(this.address());
    }

    @NativeType(value="VkRenderPassCreateFlags")
    public int flags() {
        return VkRenderPassCreateInfo2.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassCreateInfo2.nattachmentCount(this.address());
    }

    @NativeType(value="VkAttachmentDescription2 const *")
    public @Nullable VkAttachmentDescription2.Buffer pAttachments() {
        return VkRenderPassCreateInfo2.npAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpassCount() {
        return VkRenderPassCreateInfo2.nsubpassCount(this.address());
    }

    @NativeType(value="VkSubpassDescription2 const *")
    public VkSubpassDescription2.Buffer pSubpasses() {
        return VkRenderPassCreateInfo2.npSubpasses(this.address());
    }

    @NativeType(value="uint32_t")
    public int dependencyCount() {
        return VkRenderPassCreateInfo2.ndependencyCount(this.address());
    }

    @NativeType(value="VkSubpassDependency2 const *")
    public @Nullable VkSubpassDependency2.Buffer pDependencies() {
        return VkRenderPassCreateInfo2.npDependencies(this.address());
    }

    @NativeType(value="uint32_t")
    public int correlatedViewMaskCount() {
        return VkRenderPassCreateInfo2.ncorrelatedViewMaskCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pCorrelatedViewMasks() {
        return VkRenderPassCreateInfo2.npCorrelatedViewMasks(this.address());
    }

    public VkRenderPassCreateInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassCreateInfo2.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 sType$Default() {
        return this.sType(1000109004);
    }

    public VkRenderPassCreateInfo2 pNext(@NativeType(value="void const *") long value) {
        VkRenderPassCreateInfo2.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 pNext(VkRenderPassCreationControlEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo2 pNext(VkRenderPassCreationFeedbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo2 pNext(VkRenderPassFragmentDensityMapCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo2 flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
        VkRenderPassCreateInfo2.nflags(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 pAttachments(@NativeType(value="VkAttachmentDescription2 const *") @Nullable VkAttachmentDescription2.Buffer value) {
        VkRenderPassCreateInfo2.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 pSubpasses(@NativeType(value="VkSubpassDescription2 const *") VkSubpassDescription2.Buffer value) {
        VkRenderPassCreateInfo2.npSubpasses(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 pDependencies(@NativeType(value="VkSubpassDependency2 const *") @Nullable VkSubpassDependency2.Buffer value) {
        VkRenderPassCreateInfo2.npDependencies(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 pCorrelatedViewMasks(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkRenderPassCreateInfo2.npCorrelatedViewMasks(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo2 set(int sType, long pNext, int flags, @Nullable VkAttachmentDescription2.Buffer pAttachments, VkSubpassDescription2.Buffer pSubpasses, @Nullable VkSubpassDependency2.Buffer pDependencies, @Nullable IntBuffer pCorrelatedViewMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pAttachments(pAttachments);
        this.pSubpasses(pSubpasses);
        this.pDependencies(pDependencies);
        this.pCorrelatedViewMasks(pCorrelatedViewMasks);
        return this;
    }

    public VkRenderPassCreateInfo2 set(VkRenderPassCreateInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassCreateInfo2 malloc() {
        return new VkRenderPassCreateInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRenderPassCreateInfo2 calloc() {
        return new VkRenderPassCreateInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRenderPassCreateInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRenderPassCreateInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRenderPassCreateInfo2 create(long address) {
        return new VkRenderPassCreateInfo2(address, null);
    }

    public static @Nullable VkRenderPassCreateInfo2 createSafe(long address) {
        return address == 0L ? null : new VkRenderPassCreateInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRenderPassCreateInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassCreateInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderPassCreateInfo2 malloc(MemoryStack stack) {
        return new VkRenderPassCreateInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassCreateInfo2 calloc(MemoryStack stack) {
        return new VkRenderPassCreateInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHMENTCOUNT));
    }

    public static @Nullable VkAttachmentDescription2.Buffer npAttachments(long struct) {
        return VkAttachmentDescription2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), VkRenderPassCreateInfo2.nattachmentCount(struct));
    }

    public static int nsubpassCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBPASSCOUNT));
    }

    public static VkSubpassDescription2.Buffer npSubpasses(long struct) {
        return VkSubpassDescription2.create(MemoryUtil.memGetAddress((long)(struct + (long)PSUBPASSES)), VkRenderPassCreateInfo2.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEPENDENCYCOUNT));
    }

    public static @Nullable VkSubpassDependency2.Buffer npDependencies(long struct) {
        return VkSubpassDependency2.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEPENDENCIES)), VkRenderPassCreateInfo2.ndependencyCount(struct));
    }

    public static int ncorrelatedViewMaskCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CORRELATEDVIEWMASKCOUNT));
    }

    public static @Nullable IntBuffer npCorrelatedViewMasks(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCORRELATEDVIEWMASKS)), (int)VkRenderPassCreateInfo2.ncorrelatedViewMaskCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHMENTCOUNT), (int)value);
    }

    public static void npAttachments(long struct, @Nullable VkAttachmentDescription2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassCreateInfo2.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsubpassCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SUBPASSCOUNT), (int)value);
    }

    public static void npSubpasses(long struct, VkSubpassDescription2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSUBPASSES), (long)value.address());
        VkRenderPassCreateInfo2.nsubpassCount(struct, value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEPENDENCYCOUNT), (int)value);
    }

    public static void npDependencies(long struct, @Nullable VkSubpassDependency2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEPENDENCIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassCreateInfo2.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncorrelatedViewMaskCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CORRELATEDVIEWMASKCOUNT), (int)value);
    }

    public static void npCorrelatedViewMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCORRELATEDVIEWMASKS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkRenderPassCreateInfo2.ncorrelatedViewMaskCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassCreateInfo2.nattachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)));
        }
        int subpassCount = VkRenderPassCreateInfo2.nsubpassCount(struct);
        long pSubpasses = MemoryUtil.memGetAddress((long)(struct + (long)PSUBPASSES));
        Checks.check((long)pSubpasses);
        VkRenderPassCreateInfo2.validate((long)pSubpasses, (int)subpassCount, (int)VkSubpassDescription2.SIZEOF, VkSubpassDescription2::validate);
        if (VkRenderPassCreateInfo2.ndependencyCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEPENDENCIES)));
        }
        if (VkRenderPassCreateInfo2.ncorrelatedViewMaskCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCORRELATEDVIEWMASKS)));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassCreateInfo2.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassCreateInfo2.__member((int)4), VkRenderPassCreateInfo2.__member((int)POINTER_SIZE), VkRenderPassCreateInfo2.__member((int)4), VkRenderPassCreateInfo2.__member((int)4), VkRenderPassCreateInfo2.__member((int)POINTER_SIZE), VkRenderPassCreateInfo2.__member((int)4), VkRenderPassCreateInfo2.__member((int)POINTER_SIZE), VkRenderPassCreateInfo2.__member((int)4), VkRenderPassCreateInfo2.__member((int)POINTER_SIZE), VkRenderPassCreateInfo2.__member((int)4), VkRenderPassCreateInfo2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        ATTACHMENTCOUNT = layout.offsetof(3);
        PATTACHMENTS = layout.offsetof(4);
        SUBPASSCOUNT = layout.offsetof(5);
        PSUBPASSES = layout.offsetof(6);
        DEPENDENCYCOUNT = layout.offsetof(7);
        PDEPENDENCIES = layout.offsetof(8);
        CORRELATEDVIEWMASKCOUNT = layout.offsetof(9);
        PCORRELATEDVIEWMASKS = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassCreateInfo2, Buffer>
    implements NativeResource {
        private static final VkRenderPassCreateInfo2 ELEMENT_FACTORY = VkRenderPassCreateInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkRenderPassCreateInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassCreateInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassCreateInfo2.npNext(this.address());
        }

        @NativeType(value="VkRenderPassCreateFlags")
        public int flags() {
            return VkRenderPassCreateInfo2.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassCreateInfo2.nattachmentCount(this.address());
        }

        @NativeType(value="VkAttachmentDescription2 const *")
        public @Nullable VkAttachmentDescription2.Buffer pAttachments() {
            return VkRenderPassCreateInfo2.npAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpassCount() {
            return VkRenderPassCreateInfo2.nsubpassCount(this.address());
        }

        @NativeType(value="VkSubpassDescription2 const *")
        public VkSubpassDescription2.Buffer pSubpasses() {
            return VkRenderPassCreateInfo2.npSubpasses(this.address());
        }

        @NativeType(value="uint32_t")
        public int dependencyCount() {
            return VkRenderPassCreateInfo2.ndependencyCount(this.address());
        }

        @NativeType(value="VkSubpassDependency2 const *")
        public @Nullable VkSubpassDependency2.Buffer pDependencies() {
            return VkRenderPassCreateInfo2.npDependencies(this.address());
        }

        @NativeType(value="uint32_t")
        public int correlatedViewMaskCount() {
            return VkRenderPassCreateInfo2.ncorrelatedViewMaskCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pCorrelatedViewMasks() {
            return VkRenderPassCreateInfo2.npCorrelatedViewMasks(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassCreateInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000109004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassCreateInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkRenderPassCreationControlEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassCreationFeedbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassFragmentDensityMapCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
            VkRenderPassCreateInfo2.nflags(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@NativeType(value="VkAttachmentDescription2 const *") @Nullable VkAttachmentDescription2.Buffer value) {
            VkRenderPassCreateInfo2.npAttachments(this.address(), value);
            return this;
        }

        public Buffer pSubpasses(@NativeType(value="VkSubpassDescription2 const *") VkSubpassDescription2.Buffer value) {
            VkRenderPassCreateInfo2.npSubpasses(this.address(), value);
            return this;
        }

        public Buffer pDependencies(@NativeType(value="VkSubpassDependency2 const *") @Nullable VkSubpassDependency2.Buffer value) {
            VkRenderPassCreateInfo2.npDependencies(this.address(), value);
            return this;
        }

        public Buffer pCorrelatedViewMasks(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkRenderPassCreateInfo2.npCorrelatedViewMasks(this.address(), value);
            return this;
        }
    }
}

