/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;

public class VkRenderingAttachmentInfo
extends Struct<VkRenderingAttachmentInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGEVIEW;
    public static final int IMAGELAYOUT;
    public static final int RESOLVEMODE;
    public static final int RESOLVEIMAGEVIEW;
    public static final int RESOLVEIMAGELAYOUT;
    public static final int LOADOP;
    public static final int STOREOP;
    public static final int CLEARVALUE;

    protected VkRenderingAttachmentInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkRenderingAttachmentInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderingAttachmentInfo(address, container);
    }

    public VkRenderingAttachmentInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderingAttachmentInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderingAttachmentInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderingAttachmentInfo.npNext(this.address());
    }

    @NativeType(value="VkImageView")
    public long imageView() {
        return VkRenderingAttachmentInfo.nimageView(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int imageLayout() {
        return VkRenderingAttachmentInfo.nimageLayout(this.address());
    }

    @NativeType(value="VkResolveModeFlagBits")
    public int resolveMode() {
        return VkRenderingAttachmentInfo.nresolveMode(this.address());
    }

    @NativeType(value="VkImageView")
    public long resolveImageView() {
        return VkRenderingAttachmentInfo.nresolveImageView(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int resolveImageLayout() {
        return VkRenderingAttachmentInfo.nresolveImageLayout(this.address());
    }

    @NativeType(value="VkAttachmentLoadOp")
    public int loadOp() {
        return VkRenderingAttachmentInfo.nloadOp(this.address());
    }

    @NativeType(value="VkAttachmentStoreOp")
    public int storeOp() {
        return VkRenderingAttachmentInfo.nstoreOp(this.address());
    }

    public VkClearValue clearValue() {
        return VkRenderingAttachmentInfo.nclearValue(this.address());
    }

    public VkRenderingAttachmentInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingAttachmentInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo sType$Default() {
        return this.sType(1000044001);
    }

    public VkRenderingAttachmentInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderingAttachmentInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo imageView(@NativeType(value="VkImageView") long value) {
        VkRenderingAttachmentInfo.nimageView(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo imageLayout(@NativeType(value="VkImageLayout") int value) {
        VkRenderingAttachmentInfo.nimageLayout(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo resolveMode(@NativeType(value="VkResolveModeFlagBits") int value) {
        VkRenderingAttachmentInfo.nresolveMode(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo resolveImageView(@NativeType(value="VkImageView") long value) {
        VkRenderingAttachmentInfo.nresolveImageView(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo resolveImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkRenderingAttachmentInfo.nresolveImageLayout(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo loadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
        VkRenderingAttachmentInfo.nloadOp(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo storeOp(@NativeType(value="VkAttachmentStoreOp") int value) {
        VkRenderingAttachmentInfo.nstoreOp(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo clearValue(VkClearValue value) {
        VkRenderingAttachmentInfo.nclearValue(this.address(), value);
        return this;
    }

    public VkRenderingAttachmentInfo clearValue(Consumer<VkClearValue> consumer) {
        consumer.accept(this.clearValue());
        return this;
    }

    public VkRenderingAttachmentInfo set(int sType, long pNext, long imageView, int imageLayout, int resolveMode, long resolveImageView, int resolveImageLayout, int loadOp, int storeOp, VkClearValue clearValue) {
        this.sType(sType);
        this.pNext(pNext);
        this.imageView(imageView);
        this.imageLayout(imageLayout);
        this.resolveMode(resolveMode);
        this.resolveImageView(resolveImageView);
        this.resolveImageLayout(resolveImageLayout);
        this.loadOp(loadOp);
        this.storeOp(storeOp);
        this.clearValue(clearValue);
        return this;
    }

    public VkRenderingAttachmentInfo set(VkRenderingAttachmentInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderingAttachmentInfo malloc() {
        return new VkRenderingAttachmentInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRenderingAttachmentInfo calloc() {
        return new VkRenderingAttachmentInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRenderingAttachmentInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRenderingAttachmentInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRenderingAttachmentInfo create(long address) {
        return new VkRenderingAttachmentInfo(address, null);
    }

    public static @Nullable VkRenderingAttachmentInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderingAttachmentInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRenderingAttachmentInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingAttachmentInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderingAttachmentInfo malloc(MemoryStack stack) {
        return new VkRenderingAttachmentInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderingAttachmentInfo calloc(MemoryStack stack) {
        return new VkRenderingAttachmentInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nimageView(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)IMAGEVIEW));
    }

    public static int nimageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGELAYOUT));
    }

    public static int nresolveMode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESOLVEMODE));
    }

    public static long nresolveImageView(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)RESOLVEIMAGEVIEW));
    }

    public static int nresolveImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESOLVEIMAGELAYOUT));
    }

    public static int nloadOp(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOADOP));
    }

    public static int nstoreOp(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STOREOP));
    }

    public static VkClearValue nclearValue(long struct) {
        return VkClearValue.create(struct + (long)CLEARVALUE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nimageView(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)IMAGEVIEW), (long)value);
    }

    public static void nimageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGELAYOUT), (int)value);
    }

    public static void nresolveMode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESOLVEMODE), (int)value);
    }

    public static void nresolveImageView(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)RESOLVEIMAGEVIEW), (long)value);
    }

    public static void nresolveImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESOLVEIMAGELAYOUT), (int)value);
    }

    public static void nloadOp(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOADOP), (int)value);
    }

    public static void nstoreOp(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STOREOP), (int)value);
    }

    public static void nclearValue(long struct, VkClearValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CLEARVALUE), (long)VkClearValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkRenderingAttachmentInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderingAttachmentInfo.__member((int)4), VkRenderingAttachmentInfo.__member((int)POINTER_SIZE), VkRenderingAttachmentInfo.__member((int)8), VkRenderingAttachmentInfo.__member((int)4), VkRenderingAttachmentInfo.__member((int)4), VkRenderingAttachmentInfo.__member((int)8), VkRenderingAttachmentInfo.__member((int)4), VkRenderingAttachmentInfo.__member((int)4), VkRenderingAttachmentInfo.__member((int)4), VkRenderingAttachmentInfo.__member((int)VkClearValue.SIZEOF, (int)VkClearValue.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGEVIEW = layout.offsetof(2);
        IMAGELAYOUT = layout.offsetof(3);
        RESOLVEMODE = layout.offsetof(4);
        RESOLVEIMAGEVIEW = layout.offsetof(5);
        RESOLVEIMAGELAYOUT = layout.offsetof(6);
        LOADOP = layout.offsetof(7);
        STOREOP = layout.offsetof(8);
        CLEARVALUE = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkRenderingAttachmentInfo, Buffer>
    implements NativeResource {
        private static final VkRenderingAttachmentInfo ELEMENT_FACTORY = VkRenderingAttachmentInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkRenderingAttachmentInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderingAttachmentInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderingAttachmentInfo.npNext(this.address());
        }

        @NativeType(value="VkImageView")
        public long imageView() {
            return VkRenderingAttachmentInfo.nimageView(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int imageLayout() {
            return VkRenderingAttachmentInfo.nimageLayout(this.address());
        }

        @NativeType(value="VkResolveModeFlagBits")
        public int resolveMode() {
            return VkRenderingAttachmentInfo.nresolveMode(this.address());
        }

        @NativeType(value="VkImageView")
        public long resolveImageView() {
            return VkRenderingAttachmentInfo.nresolveImageView(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int resolveImageLayout() {
            return VkRenderingAttachmentInfo.nresolveImageLayout(this.address());
        }

        @NativeType(value="VkAttachmentLoadOp")
        public int loadOp() {
            return VkRenderingAttachmentInfo.nloadOp(this.address());
        }

        @NativeType(value="VkAttachmentStoreOp")
        public int storeOp() {
            return VkRenderingAttachmentInfo.nstoreOp(this.address());
        }

        public VkClearValue clearValue() {
            return VkRenderingAttachmentInfo.nclearValue(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingAttachmentInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000044001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingAttachmentInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer imageView(@NativeType(value="VkImageView") long value) {
            VkRenderingAttachmentInfo.nimageView(this.address(), value);
            return this;
        }

        public Buffer imageLayout(@NativeType(value="VkImageLayout") int value) {
            VkRenderingAttachmentInfo.nimageLayout(this.address(), value);
            return this;
        }

        public Buffer resolveMode(@NativeType(value="VkResolveModeFlagBits") int value) {
            VkRenderingAttachmentInfo.nresolveMode(this.address(), value);
            return this;
        }

        public Buffer resolveImageView(@NativeType(value="VkImageView") long value) {
            VkRenderingAttachmentInfo.nresolveImageView(this.address(), value);
            return this;
        }

        public Buffer resolveImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkRenderingAttachmentInfo.nresolveImageLayout(this.address(), value);
            return this;
        }

        public Buffer loadOp(@NativeType(value="VkAttachmentLoadOp") int value) {
            VkRenderingAttachmentInfo.nloadOp(this.address(), value);
            return this;
        }

        public Buffer storeOp(@NativeType(value="VkAttachmentStoreOp") int value) {
            VkRenderingAttachmentInfo.nstoreOp(this.address(), value);
            return this;
        }

        public Buffer clearValue(VkClearValue value) {
            VkRenderingAttachmentInfo.nclearValue(this.address(), value);
            return this;
        }

        public Buffer clearValue(Consumer<VkClearValue> consumer) {
            consumer.accept(this.clearValue());
            return this;
        }
    }
}

