/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageResolve2;

public class VkResolveImageInfo2
extends Struct<VkResolveImageInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkResolveImageInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkResolveImageInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkResolveImageInfo2(address, container);
    }

    public VkResolveImageInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkResolveImageInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkResolveImageInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkResolveImageInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkResolveImageInfo2.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkResolveImageInfo2.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkResolveImageInfo2.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkResolveImageInfo2.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkResolveImageInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkImageResolve2 const *")
    public VkImageResolve2.Buffer pRegions() {
        return VkResolveImageInfo2.npRegions(this.address());
    }

    public VkResolveImageInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkResolveImageInfo2.nsType(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 sType$Default() {
        return this.sType(1000337005);
    }

    public VkResolveImageInfo2 pNext(@NativeType(value="void const *") long value) {
        VkResolveImageInfo2.npNext(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 srcImage(@NativeType(value="VkImage") long value) {
        VkResolveImageInfo2.nsrcImage(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkResolveImageInfo2.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 dstImage(@NativeType(value="VkImage") long value) {
        VkResolveImageInfo2.ndstImage(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkResolveImageInfo2.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 pRegions(@NativeType(value="VkImageResolve2 const *") VkImageResolve2.Buffer value) {
        VkResolveImageInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkResolveImageInfo2 set(int sType, long pNext, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageResolve2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkResolveImageInfo2 set(VkResolveImageInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkResolveImageInfo2 malloc() {
        return new VkResolveImageInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkResolveImageInfo2 calloc() {
        return new VkResolveImageInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkResolveImageInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkResolveImageInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkResolveImageInfo2 create(long address) {
        return new VkResolveImageInfo2(address, null);
    }

    public static @Nullable VkResolveImageInfo2 createSafe(long address) {
        return address == 0L ? null : new VkResolveImageInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkResolveImageInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkResolveImageInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkResolveImageInfo2 malloc(MemoryStack stack) {
        return new VkResolveImageInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkResolveImageInfo2 calloc(MemoryStack stack) {
        return new VkResolveImageInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCIMAGE));
    }

    public static int nsrcImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCIMAGELAYOUT));
    }

    public static long ndstImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTIMAGE));
    }

    public static int ndstImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTIMAGELAYOUT));
    }

    public static int nregionCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGIONCOUNT));
    }

    public static VkImageResolve2.Buffer npRegions(long struct) {
        return VkImageResolve2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkResolveImageInfo2.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCIMAGE), (long)value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCIMAGELAYOUT), (int)value);
    }

    public static void ndstImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTIMAGE), (long)value);
    }

    public static void ndstImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTIMAGELAYOUT), (int)value);
    }

    public static void nregionCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGIONCOUNT), (int)value);
    }

    public static void npRegions(long struct, VkImageResolve2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkResolveImageInfo2.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkResolveImageInfo2.__struct((Struct.Member[])new Struct.Member[]{VkResolveImageInfo2.__member((int)4), VkResolveImageInfo2.__member((int)POINTER_SIZE), VkResolveImageInfo2.__member((int)8), VkResolveImageInfo2.__member((int)4), VkResolveImageInfo2.__member((int)8), VkResolveImageInfo2.__member((int)4), VkResolveImageInfo2.__member((int)4), VkResolveImageInfo2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCIMAGE = layout.offsetof(2);
        SRCIMAGELAYOUT = layout.offsetof(3);
        DSTIMAGE = layout.offsetof(4);
        DSTIMAGELAYOUT = layout.offsetof(5);
        REGIONCOUNT = layout.offsetof(6);
        PREGIONS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkResolveImageInfo2, Buffer>
    implements NativeResource {
        private static final VkResolveImageInfo2 ELEMENT_FACTORY = VkResolveImageInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkResolveImageInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkResolveImageInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkResolveImageInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkResolveImageInfo2.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkResolveImageInfo2.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkResolveImageInfo2.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkResolveImageInfo2.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkResolveImageInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkImageResolve2 const *")
        public VkImageResolve2.Buffer pRegions() {
            return VkResolveImageInfo2.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkResolveImageInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkResolveImageInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkResolveImageInfo2.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkResolveImageInfo2.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkResolveImageInfo2.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkResolveImageInfo2.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageResolve2 const *") VkImageResolve2.Buffer value) {
            VkResolveImageInfo2.npRegions(this.address(), value);
            return this;
        }
    }
}

