/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSpecializationMapEntry
extends Struct<VkSpecializationMapEntry>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONSTANTID;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkSpecializationMapEntry(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSpecializationMapEntry create(long address, @Nullable ByteBuffer container) {
        return new VkSpecializationMapEntry(address, container);
    }

    public VkSpecializationMapEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSpecializationMapEntry.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int constantID() {
        return VkSpecializationMapEntry.nconstantID(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkSpecializationMapEntry.noffset(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return VkSpecializationMapEntry.nsize(this.address());
    }

    public VkSpecializationMapEntry constantID(@NativeType(value="uint32_t") int value) {
        VkSpecializationMapEntry.nconstantID(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry offset(@NativeType(value="uint32_t") int value) {
        VkSpecializationMapEntry.noffset(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry size(@NativeType(value="size_t") long value) {
        VkSpecializationMapEntry.nsize(this.address(), value);
        return this;
    }

    public VkSpecializationMapEntry set(int constantID, int offset, long size) {
        this.constantID(constantID);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkSpecializationMapEntry set(VkSpecializationMapEntry src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSpecializationMapEntry malloc() {
        return new VkSpecializationMapEntry(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSpecializationMapEntry calloc() {
        return new VkSpecializationMapEntry(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSpecializationMapEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSpecializationMapEntry(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSpecializationMapEntry create(long address) {
        return new VkSpecializationMapEntry(address, null);
    }

    public static @Nullable VkSpecializationMapEntry createSafe(long address) {
        return address == 0L ? null : new VkSpecializationMapEntry(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSpecializationMapEntry.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSpecializationMapEntry.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSpecializationMapEntry mallocStack() {
        return VkSpecializationMapEntry.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSpecializationMapEntry callocStack() {
        return VkSpecializationMapEntry.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSpecializationMapEntry mallocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.malloc(stack);
    }

    @Deprecated
    public static VkSpecializationMapEntry callocStack(MemoryStack stack) {
        return VkSpecializationMapEntry.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSpecializationMapEntry.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSpecializationMapEntry.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSpecializationMapEntry.calloc(capacity, stack);
    }

    public static VkSpecializationMapEntry malloc(MemoryStack stack) {
        return new VkSpecializationMapEntry(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSpecializationMapEntry calloc(MemoryStack stack) {
        return new VkSpecializationMapEntry(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nconstantID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONSTANTID));
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static void nconstantID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONSTANTID), (int)value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OFFSET), (int)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkSpecializationMapEntry.__struct((Struct.Member[])new Struct.Member[]{VkSpecializationMapEntry.__member((int)4), VkSpecializationMapEntry.__member((int)4), VkSpecializationMapEntry.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONSTANTID = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationMapEntry, Buffer>
    implements NativeResource {
        private static final VkSpecializationMapEntry ELEMENT_FACTORY = VkSpecializationMapEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkSpecializationMapEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int constantID() {
            return VkSpecializationMapEntry.nconstantID(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkSpecializationMapEntry.noffset(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return VkSpecializationMapEntry.nsize(this.address());
        }

        public Buffer constantID(@NativeType(value="uint32_t") int value) {
            VkSpecializationMapEntry.nconstantID(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkSpecializationMapEntry.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            VkSpecializationMapEntry.nsize(this.address(), value);
            return this;
        }
    }
}

