/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkStridedDeviceAddressRegionKHR
extends Struct<VkStridedDeviceAddressRegionKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int STRIDE;
    public static final int SIZE;

    protected VkStridedDeviceAddressRegionKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkStridedDeviceAddressRegionKHR create(long address, @Nullable ByteBuffer container) {
        return new VkStridedDeviceAddressRegionKHR(address, container);
    }

    public VkStridedDeviceAddressRegionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkStridedDeviceAddressRegionKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long stride() {
        return VkStridedDeviceAddressRegionKHR.nstride(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkStridedDeviceAddressRegionKHR.nsize(this.address());
    }

    public VkStridedDeviceAddressRegionKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR stride(@NativeType(value="VkDeviceSize") long value) {
        VkStridedDeviceAddressRegionKHR.nstride(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR size(@NativeType(value="VkDeviceSize") long value) {
        VkStridedDeviceAddressRegionKHR.nsize(this.address(), value);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR set(long deviceAddress, long stride, long size) {
        this.deviceAddress(deviceAddress);
        this.stride(stride);
        this.size(size);
        return this;
    }

    public VkStridedDeviceAddressRegionKHR set(VkStridedDeviceAddressRegionKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkStridedDeviceAddressRegionKHR malloc() {
        return new VkStridedDeviceAddressRegionKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkStridedDeviceAddressRegionKHR calloc() {
        return new VkStridedDeviceAddressRegionKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkStridedDeviceAddressRegionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkStridedDeviceAddressRegionKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkStridedDeviceAddressRegionKHR create(long address) {
        return new VkStridedDeviceAddressRegionKHR(address, null);
    }

    public static @Nullable VkStridedDeviceAddressRegionKHR createSafe(long address) {
        return address == 0L ? null : new VkStridedDeviceAddressRegionKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkStridedDeviceAddressRegionKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkStridedDeviceAddressRegionKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkStridedDeviceAddressRegionKHR malloc(MemoryStack stack) {
        return new VkStridedDeviceAddressRegionKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkStridedDeviceAddressRegionKHR calloc(MemoryStack stack) {
        return new VkStridedDeviceAddressRegionKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndeviceAddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DEVICEADDRESS));
    }

    public static long nstride(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)STRIDE));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static void ndeviceAddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DEVICEADDRESS), (long)value);
    }

    public static void nstride(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)STRIDE), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkStridedDeviceAddressRegionKHR.__struct((Struct.Member[])new Struct.Member[]{VkStridedDeviceAddressRegionKHR.__member((int)8), VkStridedDeviceAddressRegionKHR.__member((int)8), VkStridedDeviceAddressRegionKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkStridedDeviceAddressRegionKHR, Buffer>
    implements NativeResource {
        private static final VkStridedDeviceAddressRegionKHR ELEMENT_FACTORY = VkStridedDeviceAddressRegionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkStridedDeviceAddressRegionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long stride() {
            return VkStridedDeviceAddressRegionKHR.nstride(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkStridedDeviceAddressRegionKHR.nsize(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkStridedDeviceAddressRegionKHR.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="VkDeviceSize") long value) {
            VkStridedDeviceAddressRegionKHR.nstride(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkStridedDeviceAddressRegionKHR.nsize(this.address(), value);
            return this;
        }
    }
}

