/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeAV1PictureInfo;

public class VkVideoDecodeAV1PictureInfoKHR
extends Struct<VkVideoDecodeAV1PictureInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PSTDPICTUREINFO;
    public static final int REFERENCENAMESLOTINDICES;
    public static final int FRAMEHEADEROFFSET;
    public static final int TILECOUNT;
    public static final int PTILEOFFSETS;
    public static final int PTILESIZES;

    protected VkVideoDecodeAV1PictureInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkVideoDecodeAV1PictureInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoDecodeAV1PictureInfoKHR(address, container);
    }

    public VkVideoDecodeAV1PictureInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVideoDecodeAV1PictureInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoDecodeAV1PictureInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoDecodeAV1PictureInfoKHR.npNext(this.address());
    }

    @NativeType(value="StdVideoDecodeAV1PictureInfo const *")
    public StdVideoDecodeAV1PictureInfo pStdPictureInfo() {
        return VkVideoDecodeAV1PictureInfoKHR.npStdPictureInfo(this.address());
    }

    @NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]")
    public IntBuffer referenceNameSlotIndices() {
        return VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address());
    }

    @NativeType(value="int32_t")
    public int referenceNameSlotIndices(int index) {
        return VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int frameHeaderOffset() {
        return VkVideoDecodeAV1PictureInfoKHR.nframeHeaderOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int tileCount() {
        return VkVideoDecodeAV1PictureInfoKHR.ntileCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pTileOffsets() {
        return VkVideoDecodeAV1PictureInfoKHR.npTileOffsets(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pTileSizes() {
        return VkVideoDecodeAV1PictureInfoKHR.npTileSizes(this.address());
    }

    public VkVideoDecodeAV1PictureInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoDecodeAV1PictureInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR sType$Default() {
        return this.sType(1000512001);
    }

    public VkVideoDecodeAV1PictureInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoDecodeAV1PictureInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR pStdPictureInfo(@NativeType(value="StdVideoDecodeAV1PictureInfo const *") StdVideoDecodeAV1PictureInfo value) {
        VkVideoDecodeAV1PictureInfoKHR.npStdPictureInfo(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR referenceNameSlotIndices(@NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]") IntBuffer value) {
        VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR referenceNameSlotIndices(int index, @NativeType(value="int32_t") int value) {
        VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index, value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR frameHeaderOffset(@NativeType(value="uint32_t") int value) {
        VkVideoDecodeAV1PictureInfoKHR.nframeHeaderOffset(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR tileCount(@NativeType(value="uint32_t") int value) {
        VkVideoDecodeAV1PictureInfoKHR.ntileCount(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR pTileOffsets(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkVideoDecodeAV1PictureInfoKHR.npTileOffsets(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR pTileSizes(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkVideoDecodeAV1PictureInfoKHR.npTileSizes(this.address(), value);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR set(int sType, long pNext, StdVideoDecodeAV1PictureInfo pStdPictureInfo, IntBuffer referenceNameSlotIndices, int frameHeaderOffset, int tileCount, IntBuffer pTileOffsets, IntBuffer pTileSizes) {
        this.sType(sType);
        this.pNext(pNext);
        this.pStdPictureInfo(pStdPictureInfo);
        this.referenceNameSlotIndices(referenceNameSlotIndices);
        this.frameHeaderOffset(frameHeaderOffset);
        this.tileCount(tileCount);
        this.pTileOffsets(pTileOffsets);
        this.pTileSizes(pTileSizes);
        return this;
    }

    public VkVideoDecodeAV1PictureInfoKHR set(VkVideoDecodeAV1PictureInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVideoDecodeAV1PictureInfoKHR malloc() {
        return new VkVideoDecodeAV1PictureInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkVideoDecodeAV1PictureInfoKHR calloc() {
        return new VkVideoDecodeAV1PictureInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkVideoDecodeAV1PictureInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkVideoDecodeAV1PictureInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkVideoDecodeAV1PictureInfoKHR create(long address) {
        return new VkVideoDecodeAV1PictureInfoKHR(address, null);
    }

    public static @Nullable VkVideoDecodeAV1PictureInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoDecodeAV1PictureInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkVideoDecodeAV1PictureInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoDecodeAV1PictureInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoDecodeAV1PictureInfoKHR malloc(MemoryStack stack) {
        return new VkVideoDecodeAV1PictureInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoDecodeAV1PictureInfoKHR calloc(MemoryStack stack) {
        return new VkVideoDecodeAV1PictureInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static StdVideoDecodeAV1PictureInfo npStdPictureInfo(long struct) {
        return StdVideoDecodeAV1PictureInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PSTDPICTUREINFO)));
    }

    public static IntBuffer nreferenceNameSlotIndices(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)REFERENCENAMESLOTINDICES), (int)7);
    }

    public static int nreferenceNameSlotIndices(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFERENCENAMESLOTINDICES + Checks.check((int)index, (int)7) * 4L));
    }

    public static int nframeHeaderOffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FRAMEHEADEROFFSET));
    }

    public static int ntileCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TILECOUNT));
    }

    public static IntBuffer npTileOffsets(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PTILEOFFSETS)), (int)VkVideoDecodeAV1PictureInfoKHR.ntileCount(struct));
    }

    public static IntBuffer npTileSizes(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PTILESIZES)), (int)VkVideoDecodeAV1PictureInfoKHR.ntileCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npStdPictureInfo(long struct, StdVideoDecodeAV1PictureInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTDPICTUREINFO), (long)value.address());
    }

    public static void nreferenceNameSlotIndices(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)REFERENCENAMESLOTINDICES), (long)(value.remaining() * 4));
    }

    public static void nreferenceNameSlotIndices(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFERENCENAMESLOTINDICES + Checks.check((int)index, (int)7) * 4L), (int)value);
    }

    public static void nframeHeaderOffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FRAMEHEADEROFFSET), (int)value);
    }

    public static void ntileCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TILECOUNT), (int)value);
    }

    public static void npTileOffsets(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTILEOFFSETS), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void npTileSizes(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTILESIZES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void validate(long struct) {
        long pStdPictureInfo = MemoryUtil.memGetAddress((long)(struct + (long)PSTDPICTUREINFO));
        Checks.check((long)pStdPictureInfo);
        StdVideoDecodeAV1PictureInfo.validate(pStdPictureInfo);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PTILEOFFSETS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PTILESIZES)));
    }

    static {
        Struct.Layout layout = VkVideoDecodeAV1PictureInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkVideoDecodeAV1PictureInfoKHR.__member((int)4), VkVideoDecodeAV1PictureInfoKHR.__member((int)POINTER_SIZE), VkVideoDecodeAV1PictureInfoKHR.__member((int)POINTER_SIZE), VkVideoDecodeAV1PictureInfoKHR.__array((int)4, (int)7), VkVideoDecodeAV1PictureInfoKHR.__member((int)4), VkVideoDecodeAV1PictureInfoKHR.__member((int)4), VkVideoDecodeAV1PictureInfoKHR.__member((int)POINTER_SIZE), VkVideoDecodeAV1PictureInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PSTDPICTUREINFO = layout.offsetof(2);
        REFERENCENAMESLOTINDICES = layout.offsetof(3);
        FRAMEHEADEROFFSET = layout.offsetof(4);
        TILECOUNT = layout.offsetof(5);
        PTILEOFFSETS = layout.offsetof(6);
        PTILESIZES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkVideoDecodeAV1PictureInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoDecodeAV1PictureInfoKHR ELEMENT_FACTORY = VkVideoDecodeAV1PictureInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkVideoDecodeAV1PictureInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoDecodeAV1PictureInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoDecodeAV1PictureInfoKHR.npNext(this.address());
        }

        @NativeType(value="StdVideoDecodeAV1PictureInfo const *")
        public StdVideoDecodeAV1PictureInfo pStdPictureInfo() {
            return VkVideoDecodeAV1PictureInfoKHR.npStdPictureInfo(this.address());
        }

        @NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]")
        public IntBuffer referenceNameSlotIndices() {
            return VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address());
        }

        @NativeType(value="int32_t")
        public int referenceNameSlotIndices(int index) {
            return VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int frameHeaderOffset() {
            return VkVideoDecodeAV1PictureInfoKHR.nframeHeaderOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int tileCount() {
            return VkVideoDecodeAV1PictureInfoKHR.ntileCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pTileOffsets() {
            return VkVideoDecodeAV1PictureInfoKHR.npTileOffsets(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pTileSizes() {
            return VkVideoDecodeAV1PictureInfoKHR.npTileSizes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoDecodeAV1PictureInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000512001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoDecodeAV1PictureInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pStdPictureInfo(@NativeType(value="StdVideoDecodeAV1PictureInfo const *") StdVideoDecodeAV1PictureInfo value) {
            VkVideoDecodeAV1PictureInfoKHR.npStdPictureInfo(this.address(), value);
            return this;
        }

        public Buffer referenceNameSlotIndices(@NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]") IntBuffer value) {
            VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), value);
            return this;
        }

        public Buffer referenceNameSlotIndices(int index, @NativeType(value="int32_t") int value) {
            VkVideoDecodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index, value);
            return this;
        }

        public Buffer frameHeaderOffset(@NativeType(value="uint32_t") int value) {
            VkVideoDecodeAV1PictureInfoKHR.nframeHeaderOffset(this.address(), value);
            return this;
        }

        public Buffer tileCount(@NativeType(value="uint32_t") int value) {
            VkVideoDecodeAV1PictureInfoKHR.ntileCount(this.address(), value);
            return this;
        }

        public Buffer pTileOffsets(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkVideoDecodeAV1PictureInfoKHR.npTileOffsets(this.address(), value);
            return this;
        }

        public Buffer pTileSizes(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkVideoDecodeAV1PictureInfoKHR.npTileSizes(this.address(), value);
            return this;
        }
    }
}

