/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoEncodeAV1SessionCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeH264SessionCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeH265SessionCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoProfileInfoKHR;

public class VkVideoSessionCreateInfoKHR
extends Struct<VkVideoSessionCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int QUEUEFAMILYINDEX;
    public static final int FLAGS;
    public static final int PVIDEOPROFILE;
    public static final int PICTUREFORMAT;
    public static final int MAXCODEDEXTENT;
    public static final int REFERENCEPICTUREFORMAT;
    public static final int MAXDPBSLOTS;
    public static final int MAXACTIVEREFERENCEPICTURES;
    public static final int PSTDHEADERVERSION;

    protected VkVideoSessionCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkVideoSessionCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoSessionCreateInfoKHR(address, container);
    }

    public VkVideoSessionCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVideoSessionCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoSessionCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoSessionCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="VkVideoSessionCreateFlagsKHR")
    public int flags() {
        return VkVideoSessionCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoProfileInfoKHR const *")
    public VkVideoProfileInfoKHR pVideoProfile() {
        return VkVideoSessionCreateInfoKHR.npVideoProfile(this.address());
    }

    @NativeType(value="VkFormat")
    public int pictureFormat() {
        return VkVideoSessionCreateInfoKHR.npictureFormat(this.address());
    }

    public VkExtent2D maxCodedExtent() {
        return VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address());
    }

    @NativeType(value="VkFormat")
    public int referencePictureFormat() {
        return VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDpbSlots() {
        return VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxActiveReferencePictures() {
        return VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address());
    }

    @NativeType(value="VkExtensionProperties const *")
    public VkExtensionProperties pStdHeaderVersion() {
        return VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address());
    }

    public VkVideoSessionCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoSessionCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR sType$Default() {
        return this.sType(1000023005);
    }

    public VkVideoSessionCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoSessionCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeAV1SessionCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeH264SessionCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeH265SessionCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR flags(@NativeType(value="VkVideoSessionCreateFlagsKHR") int value) {
        VkVideoSessionCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pVideoProfile(@NativeType(value="VkVideoProfileInfoKHR const *") VkVideoProfileInfoKHR value) {
        VkVideoSessionCreateInfoKHR.npVideoProfile(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pictureFormat(@NativeType(value="VkFormat") int value) {
        VkVideoSessionCreateInfoKHR.npictureFormat(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxCodedExtent(VkExtent2D value) {
        VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxCodedExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxCodedExtent());
        return this;
    }

    public VkVideoSessionCreateInfoKHR referencePictureFormat(@NativeType(value="VkFormat") int value) {
        VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxDpbSlots(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxActiveReferencePictures(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pStdHeaderVersion(@NativeType(value="VkExtensionProperties const *") VkExtensionProperties value) {
        VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR set(int sType, long pNext, int queueFamilyIndex, int flags, VkVideoProfileInfoKHR pVideoProfile, int pictureFormat, VkExtent2D maxCodedExtent, int referencePictureFormat, int maxDpbSlots, int maxActiveReferencePictures, VkExtensionProperties pStdHeaderVersion) {
        this.sType(sType);
        this.pNext(pNext);
        this.queueFamilyIndex(queueFamilyIndex);
        this.flags(flags);
        this.pVideoProfile(pVideoProfile);
        this.pictureFormat(pictureFormat);
        this.maxCodedExtent(maxCodedExtent);
        this.referencePictureFormat(referencePictureFormat);
        this.maxDpbSlots(maxDpbSlots);
        this.maxActiveReferencePictures(maxActiveReferencePictures);
        this.pStdHeaderVersion(pStdHeaderVersion);
        return this;
    }

    public VkVideoSessionCreateInfoKHR set(VkVideoSessionCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVideoSessionCreateInfoKHR malloc() {
        return new VkVideoSessionCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkVideoSessionCreateInfoKHR calloc() {
        return new VkVideoSessionCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkVideoSessionCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkVideoSessionCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkVideoSessionCreateInfoKHR create(long address) {
        return new VkVideoSessionCreateInfoKHR(address, null);
    }

    public static @Nullable VkVideoSessionCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoSessionCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkVideoSessionCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoSessionCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoSessionCreateInfoKHR malloc(MemoryStack stack) {
        return new VkVideoSessionCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoSessionCreateInfoKHR calloc(MemoryStack stack) {
        return new VkVideoSessionCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nqueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUEFAMILYINDEX));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static VkVideoProfileInfoKHR npVideoProfile(long struct) {
        return VkVideoProfileInfoKHR.create(MemoryUtil.memGetAddress((long)(struct + (long)PVIDEOPROFILE)));
    }

    public static int npictureFormat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PICTUREFORMAT));
    }

    public static VkExtent2D nmaxCodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXCODEDEXTENT);
    }

    public static int nreferencePictureFormat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFERENCEPICTUREFORMAT));
    }

    public static int nmaxDpbSlots(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXDPBSLOTS));
    }

    public static int nmaxActiveReferencePictures(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXACTIVEREFERENCEPICTURES));
    }

    public static VkExtensionProperties npStdHeaderVersion(long struct) {
        return VkExtensionProperties.create(MemoryUtil.memGetAddress((long)(struct + (long)PSTDHEADERVERSION)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)QUEUEFAMILYINDEX), (int)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void npVideoProfile(long struct, VkVideoProfileInfoKHR value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVIDEOPROFILE), (long)value.address());
    }

    public static void npictureFormat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PICTUREFORMAT), (int)value);
    }

    public static void nmaxCodedExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MAXCODEDEXTENT), (long)VkExtent2D.SIZEOF);
    }

    public static void nreferencePictureFormat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFERENCEPICTUREFORMAT), (int)value);
    }

    public static void nmaxDpbSlots(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXDPBSLOTS), (int)value);
    }

    public static void nmaxActiveReferencePictures(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXACTIVEREFERENCEPICTURES), (int)value);
    }

    public static void npStdHeaderVersion(long struct, VkExtensionProperties value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTDHEADERVERSION), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIDEOPROFILE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSTDHEADERVERSION)));
    }

    static {
        Struct.Layout layout = VkVideoSessionCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)POINTER_SIZE), VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)POINTER_SIZE), VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)4), VkVideoSessionCreateInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        QUEUEFAMILYINDEX = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        PVIDEOPROFILE = layout.offsetof(4);
        PICTUREFORMAT = layout.offsetof(5);
        MAXCODEDEXTENT = layout.offsetof(6);
        REFERENCEPICTUREFORMAT = layout.offsetof(7);
        MAXDPBSLOTS = layout.offsetof(8);
        MAXACTIVEREFERENCEPICTURES = layout.offsetof(9);
        PSTDHEADERVERSION = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkVideoSessionCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoSessionCreateInfoKHR ELEMENT_FACTORY = VkVideoSessionCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkVideoSessionCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoSessionCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoSessionCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="VkVideoSessionCreateFlagsKHR")
        public int flags() {
            return VkVideoSessionCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoProfileInfoKHR const *")
        public VkVideoProfileInfoKHR pVideoProfile() {
            return VkVideoSessionCreateInfoKHR.npVideoProfile(this.address());
        }

        @NativeType(value="VkFormat")
        public int pictureFormat() {
            return VkVideoSessionCreateInfoKHR.npictureFormat(this.address());
        }

        public VkExtent2D maxCodedExtent() {
            return VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address());
        }

        @NativeType(value="VkFormat")
        public int referencePictureFormat() {
            return VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDpbSlots() {
            return VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxActiveReferencePictures() {
            return VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address());
        }

        @NativeType(value="VkExtensionProperties const *")
        public VkExtensionProperties pStdHeaderVersion() {
            return VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoSessionCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoSessionCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeAV1SessionCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264SessionCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265SessionCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkVideoSessionCreateFlagsKHR") int value) {
            VkVideoSessionCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pVideoProfile(@NativeType(value="VkVideoProfileInfoKHR const *") VkVideoProfileInfoKHR value) {
            VkVideoSessionCreateInfoKHR.npVideoProfile(this.address(), value);
            return this;
        }

        public Buffer pictureFormat(@NativeType(value="VkFormat") int value) {
            VkVideoSessionCreateInfoKHR.npictureFormat(this.address(), value);
            return this;
        }

        public Buffer maxCodedExtent(VkExtent2D value) {
            VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address(), value);
            return this;
        }

        public Buffer maxCodedExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxCodedExtent());
            return this;
        }

        public Buffer referencePictureFormat(@NativeType(value="VkFormat") int value) {
            VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address(), value);
            return this;
        }

        public Buffer maxDpbSlots(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address(), value);
            return this;
        }

        public Buffer maxActiveReferencePictures(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address(), value);
            return this;
        }

        public Buffer pStdHeaderVersion(@NativeType(value="VkExtensionProperties const *") VkExtensionProperties value) {
            VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address(), value);
            return this;
        }
    }
}

